/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.tools.generator;

import dev.dsf.tools.generator.CertificateGenerator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvGenerator {
    private static final Logger logger = LoggerFactory.getLogger(EnvGenerator.class);
    private static final String BUNDLE_USER_THUMBPRINT = "BUNDLE_USER_THUMBPRINT";
    private static final String WEBBROSER_TEST_USER_THUMBPRINT = "WEBBROSER_TEST_USER_THUMBPRINT";

    public void generateAndWriteDockerTestFhirEnvFile(Map<String, CertificateGenerator.CertificateFiles> clientCertificateFilesByCommonName) {
        String bundleUserThumbprint = this.filterAndMapToThumbprint(clientCertificateFilesByCommonName, "test-client").findFirst().get();
        String webbroserTestUserThumbprint = this.filterAndMapToThumbprint(clientCertificateFilesByCommonName, "Webbrowser Test User").findFirst().get();
        this.writeEnvFile(Paths.get("../../dsf-docker-test-setup/fhir/.env", new String[0]), List.of(new EnvEntry(BUNDLE_USER_THUMBPRINT, bundleUserThumbprint), new EnvEntry(WEBBROSER_TEST_USER_THUMBPRINT, webbroserTestUserThumbprint)));
    }

    public void generateAndWriteDockerTest3DicTtpDockerFhirEnvFiles(Map<String, CertificateGenerator.CertificateFiles> clientCertificateFilesByCommonName) {
        String webbroserTestUserThumbprint = this.filterAndMapToThumbprint(clientCertificateFilesByCommonName, "Webbrowser Test User").findFirst().get();
        String bundleDic1UserThumbprint = this.filterAndMapToThumbprint(clientCertificateFilesByCommonName, "dic1-client").findFirst().get();
        String bundleDic2UserThumbprint = this.filterAndMapToThumbprint(clientCertificateFilesByCommonName, "dic2-client").findFirst().get();
        String bundleDic3UserThumbprint = this.filterAndMapToThumbprint(clientCertificateFilesByCommonName, "dic3-client").findFirst().get();
        String bundleTtpUserThumbprint = this.filterAndMapToThumbprint(clientCertificateFilesByCommonName, "ttp-client").findFirst().get();
        List<EnvEntry> entries = List.of(new EnvEntry(WEBBROSER_TEST_USER_THUMBPRINT, webbroserTestUserThumbprint), new EnvEntry("DIC1_BUNDLE_USER_THUMBPRINT", bundleDic1UserThumbprint), new EnvEntry("DIC2_BUNDLE_USER_THUMBPRINT", bundleDic2UserThumbprint), new EnvEntry("DIC3_BUNDLE_USER_THUMBPRINT", bundleDic3UserThumbprint), new EnvEntry("TTP_BUNDLE_USER_THUMBPRINT", bundleTtpUserThumbprint));
        this.writeEnvFile(Paths.get("../../dsf-docker-test-setup-3dic-ttp/.env", new String[0]), entries);
    }

    private Stream<String> filterAndMapToThumbprint(Map<String, CertificateGenerator.CertificateFiles> clientCertificateFilesByCommonName, String ... commonNames) {
        return clientCertificateFilesByCommonName.entrySet().stream().filter(entry -> Arrays.asList(commonNames).contains(entry.getKey())).sorted(Comparator.comparing(e -> Arrays.asList(commonNames).indexOf(e.getKey()))).map(Map.Entry::getValue).map(CertificateGenerator.CertificateFiles::getCertificateSha512ThumbprintHex);
    }

    private void writeEnvFile(Path target, List<? extends EnvEntry> entries) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < entries.size(); ++i) {
            EnvEntry entry = entries.get(i);
            builder.append(entry.userThumbprintVariableName);
            builder.append('=');
            builder.append(entry.userThumbprint);
            if (i + 1 >= entries.size()) continue;
            builder.append("\n");
        }
        try {
            logger.info("Writing .env file to {}", (Object)target.toString());
            Files.writeString(target, (CharSequence)builder.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Error while writing .env file to " + target.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static final class EnvEntry {
        final String userThumbprintVariableName;
        final String userThumbprint;

        EnvEntry(String userThumbprintVariableName, String userThumbprint) {
            this.userThumbprintVariableName = userThumbprintVariableName;
            this.userThumbprint = userThumbprint;
        }
    }
}

