/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.tools.generator;

import dev.dsf.bpe.v1.ProcessPluginDefinition;
import dev.dsf.bpe.v1.documentation.ProcessDocumentation;
import dev.dsf.common.documentation.Documentation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class DocumentationGenerator
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(DocumentationGenerator.class);
    private static final String ENV_VARIABLE_PLACEHOLDER = "${env_variable}";
    private static final String PROPERTY_NAME_PLACEHOLDER = " ${property_name}";
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private String projectBuildDirectory;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compileClasspathElements;
    @Parameter(property="workingPackages", required=true)
    private List<String> workingPackages;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.workingPackages.forEach(this::generateDocumentation);
    }

    private void generateDocumentation(String workingPackage) {
        Set processFields;
        Path file = Paths.get(this.projectBuildDirectory, "Documentation_" + workingPackage + ".md");
        logger.info("Generating documentation for package {} in file {}", (Object)workingPackage, (Object)file);
        this.moveExistingToBackup(file);
        URLClassLoader classLoader = this.classLoader();
        Reflections reflections = this.createReflections(classLoader, workingPackage);
        Set dsfFields = reflections.getFieldsAnnotatedWith(Documentation.class);
        if (!dsfFields.isEmpty()) {
            this.writeFields(dsfFields, this.dsfDocumentationGenerator(), file, workingPackage);
        }
        if (!(processFields = reflections.getFieldsAnnotatedWith(ProcessDocumentation.class)).isEmpty()) {
            List<String> pluginProcessNames = this.getPluginProcessNames(reflections, classLoader, workingPackage);
            this.writeFields(processFields, this.processDocumentationGenerator(pluginProcessNames), file, workingPackage);
        }
    }

    private Reflections createReflections(ClassLoader classLoader, String workingPackage) {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)workingPackage, (ClassLoader[])new ClassLoader[]{classLoader})).addClassLoaders(new ClassLoader[]{classLoader}).setScanners(new Scanner[]{Scanners.FieldsAnnotated, Scanners.SubTypes});
        return new Reflections((Configuration)configurationBuilder);
    }

    private URLClassLoader classLoader() {
        URL[] classpathElements = (URL[])this.compileClasspathElements.stream().map(this::toUrl).filter(Objects::nonNull).toArray(URL[]::new);
        return new URLClassLoader(classpathElements, Thread.currentThread().getContextClassLoader());
    }

    private URL toUrl(String path) {
        try {
            return new File(path).toURI().toURL();
        }
        catch (MalformedURLException exception) {
            logger.warn("Could not transform path '{}' to url, returning null - {}", (Object)path, (Object)exception.getMessage());
            return null;
        }
    }

    private List<String> getPluginProcessNames(Reflections reflections, ClassLoader classLoader, String workingPackage) {
        ArrayList pluginDefinitionClasses = new ArrayList(reflections.getSubTypesOf(ProcessPluginDefinition.class));
        if (pluginDefinitionClasses.size() < 1) {
            logger.warn("No ProcessPluginDefinitions found in package {}", (Object)workingPackage);
            return Collections.emptyList();
        }
        if (pluginDefinitionClasses.size() > 1) {
            logger.warn("Found {} ProcessPluginDefinitions ({}) in package {}, using {}", new Object[]{pluginDefinitionClasses.size(), pluginDefinitionClasses, workingPackage, ((Class)pluginDefinitionClasses.get(0)).getName()});
        }
        try {
            ProcessPluginDefinition processPluginDefinition = (ProcessPluginDefinition)((Class)pluginDefinitionClasses.get(0)).getConstructor(new Class[0]).newInstance(new Object[0]);
            return processPluginDefinition.getProcessModels().stream().map(f -> this.getProcessName(classLoader, (String)f)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Could not read process names from package {} and ProcessPluginDefinition with name {}: {} {}", new Object[]{workingPackage, ((Class)pluginDefinitionClasses.get(0)).getName(), e.getClass().getSimpleName(), e.getMessage()});
            return Collections.emptyList();
        }
    }

    private Optional<String> getProcessName(ClassLoader classLoader, String bpmnFile) {
        Optional<String> optional;
        block8: {
            InputStream resource = classLoader.getResourceAsStream(bpmnFile);
            try {
                optional = Bpmn.readModelFromStream((InputStream)resource).getModelElementsByType(Process.class).stream().map(BaseElement::getId).findFirst();
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    logger.warn("Could not read process name from resource file {}: {}", (Object)bpmnFile, (Object)exception.getMessage());
                    return Optional.empty();
                }
            }
            resource.close();
        }
        return optional;
    }

    private void moveExistingToBackup(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            Path backupFile = file.resolveSibling(file.getFileName() + ".backup");
            try {
                logger.warn("Documentation file at {} exists, moving old file to {}", (Object)file, (Object)backupFile);
                Files.move(file, backupFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                logger.error("Could not move {} to {}: {} {}", new Object[]{file, backupFile, e.getClass().getSimpleName(), e.getMessage()});
            }
        }
    }

    private void writeFields(Collection<? extends Field> fields, Function<Field, DocumentationEntry> documentationGenerator, Path file, String workingPackage) {
        Iterable entries = fields.stream().map(documentationGenerator).sorted(Comparator.comparing(DocumentationEntry::propertyName, String.CASE_INSENSITIVE_ORDER)).map(DocumentationEntry::value)::iterator;
        try {
            Files.write(file, entries, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            logger.error("Could not generate documentation for package {}: {} {}", new Object[]{workingPackage, e.getClass().getSimpleName(), e.getMessage()});
        }
    }

    private Function<Field, DocumentationEntry> processDocumentationGenerator(List<String> pluginProcessNames) {
        return field -> {
            ProcessDocumentation documentation = field.getAnnotation(ProcessDocumentation.class);
            Value value = field.getAnnotation(Value.class);
            String[] valueSplit = this.getValueDefaultArray(value);
            String initialProperty = valueSplit.length > 0 ? valueSplit[0] : "";
            String property = this.getDocumentationString("Property", initialProperty);
            String initialEnvironment = initialProperty.replace(".", "_").toUpperCase();
            String environment = initialProperty.endsWith(".password") ? String.format("%s or %s_FILE", initialEnvironment, initialEnvironment) : initialEnvironment;
            String required = this.getDocumentationString("Required", documentation.required() ? "Yes" : "No");
            String[] processNames = documentation.processNames();
            String processes = this.getDocumentationString("Processes", this.getProcessNamesAsString(processNames, pluginProcessNames));
            String description = this.getDocumentationString("Description", documentation.description());
            String recommendation = this.getDocumentationString("Recommendation", documentation.recommendation());
            String example = this.getDocumentationStringMonospace("Example", documentation.example());
            String defaultValue = valueSplit.length > 1 && !"null".equals(valueSplit[1]) ? this.getDocumentationStringMonospace("Default", valueSplit[1]) : "";
            return new DocumentationEntry(initialProperty, String.format("### %s%n%s%s%s%s%s%s%s%n", environment, property, required, processes, description, recommendation, example, defaultValue).replace(ENV_VARIABLE_PLACEHOLDER, initialEnvironment).replace(PROPERTY_NAME_PLACEHOLDER, initialProperty));
        };
    }

    private Function<Field, DocumentationEntry> dsfDocumentationGenerator() {
        return field -> {
            Documentation documentation = field.getAnnotation(Documentation.class);
            Value value = field.getAnnotation(Value.class);
            String[] valueSplit = this.getValueDefaultArray(value);
            String initialProperty = valueSplit.length > 0 ? valueSplit[0] : "";
            String property = this.getDocumentationString("Property", initialProperty);
            String initialEnvironment = initialProperty.replace(".", "_").toUpperCase();
            String environment = initialProperty.endsWith(".password") ? String.format("%s or %s_FILE", initialEnvironment, initialEnvironment) : initialEnvironment;
            String required = this.getDocumentationString("Required", documentation.required() ? "Yes" : "No");
            String description = this.getDocumentationString("Description", documentation.description());
            String recommendation = this.getDocumentationString("Recommendation", documentation.recommendation());
            String example = this.getDocumentationStringMonospace("Example", documentation.example());
            String defaultValue = valueSplit.length > 1 && !"null".equals(valueSplit[1]) ? this.getDocumentationStringMonospace("Default", valueSplit[1]) : "";
            return new DocumentationEntry(initialProperty, String.format("### %s%n%s%s%s%s%s%s%n", environment, property, required, description, recommendation, example, defaultValue).replace(ENV_VARIABLE_PLACEHOLDER, initialEnvironment).replace(PROPERTY_NAME_PLACEHOLDER, initialProperty));
        };
    }

    private String[] getValueDefaultArray(Value value) {
        if (value == null) {
            return new String[0];
        }
        String valueString = value.value();
        if (valueString.startsWith("#{'")) {
            valueString = valueString.substring(valueString.indexOf("#{'") + 4, valueString.indexOf("}'"));
        }
        return valueString.replaceAll("\\$", "").replace("#", "").replace("{", "").replace("}", "").split(":");
    }

    private String getDocumentationStringMonospace(String title, String value) {
        if (title == null || title.isBlank() || value == null || value.isBlank()) {
            return "";
        }
        return String.format("- **%s:** `%s`%n", title, value);
    }

    private String getDocumentationString(String title, String value) {
        if (title == null || title.isBlank() || value == null || value.isBlank()) {
            return "";
        }
        return String.format("- **%s:** %s%n", title, value);
    }

    private String getProcessNamesAsString(String[] documentationProcessNames, List<String> pluginProcessNames) {
        if (pluginProcessNames.size() == 0) {
            return "Could not read process names from ProcessPluginDefinition";
        }
        if (documentationProcessNames.length == 0) {
            return String.join((CharSequence)", ", pluginProcessNames);
        }
        for (String documentationProcessName : documentationProcessNames) {
            if (pluginProcessNames.contains(documentationProcessName)) continue;
            logger.warn("Documentation contains process with name '{}' which is not part of the processes {} defined in the ProcessPluginDefinition", (Object)documentationProcessName, pluginProcessNames);
        }
        return String.join((CharSequence)", ", documentationProcessNames);
    }

    private record DocumentationEntry(String propertyName, String value) {
    }
}

