/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.tools.db;

import dev.dsf.tools.db.DbMigratorConfig;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.command.CommandScope;
import liquibase.command.core.ReleaseLocksCommandStep;
import liquibase.command.core.UpdateCommandStep;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ui.LoggerUIService;
import org.apache.commons.dbcp2.BasicDataSource;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbMigrator {
    private static final Logger logger = LoggerFactory.getLogger(DbMigrator.class);
    private final DbMigratorConfig config;

    public DbMigrator(DbMigratorConfig config) {
        this.config = config;
    }

    public void migrate() {
        try {
            Scope.child((Enum)Scope.Attr.ui, (Object)new LoggerUIService(), () -> {
                try (BasicDataSource dataSource = new BasicDataSource();){
                    dataSource.setDriverClassName(Driver.class.getName());
                    dataSource.setUrl(this.config.getDbUrl());
                    dataSource.setUsername(this.config.getDbLiquibaseUsername());
                    dataSource.setPassword(this.toString(this.config.getDbLiquibasePassword()));
                    LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
                    liquibaseConfiguration.registerProvider((ConfigurationValueProvider)new LiquibaseConfigProvider(this.config.getLiquibaseLockWaitTime()));
                    try (Connection connection = dataSource.getConnection();){
                        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
                        if (this.config.forceLiquibaseUnlock()) {
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            CommandScope unlockCommand = new CommandScope(ReleaseLocksCommandStep.COMMAND_NAME);
                            unlockCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, (Object)database);
                            unlockCommand.setOutput((OutputStream)output);
                            logger.warn("Unlocking DB for migration ...");
                            unlockCommand.execute();
                            Arrays.stream(output.toString().split("[\r\n]+")).filter(row -> !row.isBlank()).forEach(row -> logger.debug("{}", row));
                            logger.warn("Unlocking DB for migration [Done]");
                        }
                        ChangeLogParameters changeLogParameters = new ChangeLogParameters(database);
                        this.config.getChangeLogParameters().forEach((arg_0, arg_1) -> ((ChangeLogParameters)changeLogParameters).set(arg_0, arg_1));
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        CommandScope updateCommand = new CommandScope(UpdateCommandStep.COMMAND_NAME);
                        updateCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, (Object)database);
                        updateCommand.addArgumentValue(UpdateCommandStep.CHANGELOG_FILE_ARG, (Object)"db/db.changelog.xml");
                        updateCommand.addArgumentValue(UpdateCommandStep.CONTEXTS_ARG, (Object)new Contexts().toString());
                        updateCommand.addArgumentValue(UpdateCommandStep.LABEL_FILTER_ARG, (Object)new LabelExpression().getOriginalString());
                        updateCommand.addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_PARAMETERS, (Object)changeLogParameters);
                        updateCommand.setOutput((OutputStream)output);
                        logger.info("Executing DB migration ...");
                        updateCommand.execute();
                        Arrays.stream(output.toString().split("[\r\n]+")).filter(row -> !row.isBlank()).forEach(row -> logger.debug("{}", row));
                        logger.info("Executing DB migration [Done]");
                    }
                }
                catch (SQLException e) {
                    logger.warn("Error while accessing db: {}", (Object)e.getMessage());
                    throw new DbMigratorExceptions(e);
                }
                catch (Exception e) {
                    logger.warn("Error while running liquibase: {}", (Object)e.getMessage());
                    throw new DbMigratorExceptions(e);
                }
            });
        }
        catch (DbMigratorExceptions e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Error while running liquibase: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private String toString(char[] password) {
        return password == null ? null : String.valueOf(password);
    }

    public static void retryOnConnectException(int times, Runnable run) {
        if (times <= 0) {
            return;
        }
        try {
            run.run();
        }
        catch (RuntimeException e) {
            Throwable cause = e;
            while (!(cause instanceof ConnectException) && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof ConnectException && times > 1) {
                logger.warn("ConnectException: trying again in 5s");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DbMigrator.retryOnConnectException(--times, run);
            }
            if (cause instanceof UnknownHostException && times > 1) {
                logger.warn("UnknownHostException: trying again in 10s");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DbMigrator.retryOnConnectException(--times, run);
            }
            logger.error("Error while running liquibase: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private static final class DbMigratorExceptions
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        DbMigratorExceptions(Throwable cause) {
            super(cause);
        }
    }

    private static final class LiquibaseConfigProvider
    extends AbstractMapConfigurationValueProvider {
        static final String LIQUIBASE_CHANGELOGLOCK_WAIT_TIME = "liquibase.changelogLockWaitTimeInMinutes";
        final Map<String, Object> map = new HashMap<String, Object>();

        LiquibaseConfigProvider(long changelogLockWaitTimeInMinutes) {
            this.map.put(LIQUIBASE_CHANGELOGLOCK_WAIT_TIME, changelogLockWaitTimeInMinutes);
        }

        public int getPrecedence() {
            return 350;
        }

        protected Map<?, ?> getMap() {
            return this.map;
        }

        protected String getSourceDescription() {
            return "DSF config";
        }
    }
}

