/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import ca.uhn.fhir.parser.IParser;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.DomainResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEndpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(ClientEndpoint.class);
    private final Runnable reconnector;
    private final String subscriptionIdPart;
    private Supplier<IParser> parserFactory;
    private Consumer<DomainResource> domainResourceHandler;
    private Consumer<String> pingHandler;

    public ClientEndpoint(Runnable reconnector, String subscriptionIdPart) {
        this.reconnector = reconnector;
        this.subscriptionIdPart = subscriptionIdPart;
    }

    public void onOpen(Session session, EndpointConfig config) {
        logger.info("Websocket connected {uri: {}, session-id: {}}", (Object)session.getRequestURI().toString(), (Object)session.getId());
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){
            private boolean boundReceived;

            public void onMessage(String message) {
                logger.debug("onMessage {}", (Object)message);
                if (("bound " + ClientEndpoint.this.subscriptionIdPart).equals(message)) {
                    logger.debug("Bound received");
                    this.boundReceived = true;
                    return;
                }
                if (this.boundReceived) {
                    try {
                        if (ClientEndpoint.this.pingHandler != null && ("ping " + ClientEndpoint.this.subscriptionIdPart).equals(message)) {
                            ClientEndpoint.this.pingHandler.accept(message);
                        } else if (ClientEndpoint.this.domainResourceHandler != null && ClientEndpoint.this.parserFactory != null) {
                            ClientEndpoint.this.domainResourceHandler.accept((DomainResource)ClientEndpoint.this.parserFactory.get().parseResource(message));
                        }
                    }
                    catch (Throwable e) {
                        logger.error("Error while handling message, caught {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                    }
                }
            }
        });
        session.getAsyncRemote().sendText("bind " + this.subscriptionIdPart);
    }

    public void onClose(Session session, CloseReason closeReason) {
        logger.info("Websocket closed {uri: {}, session-id: {}}: {}", new Object[]{session.getRequestURI().toString(), session.getId(), closeReason.getReasonPhrase()});
        if (CloseReason.CloseCodes.CANNOT_ACCEPT.equals((Object)closeReason.getCloseCode())) {
            logger.info("Trying to reconnect websocket");
            this.reconnector.run();
        }
    }

    public void onError(Session session, Throwable throwable) {
        logger.warn("Websocket closed with error {uri: " + session.getRequestURI().toString() + ", session-id: " + session.getId() + "}: {}", throwable);
    }

    public void setDomainResourceHandler(Consumer<DomainResource> handler, Supplier<IParser> parser) {
        this.domainResourceHandler = handler;
        this.parserFactory = parser;
        this.pingHandler = null;
    }

    public void setPingHandler(Consumer<String> handler) {
        this.domainResourceHandler = null;
        this.parserFactory = null;
        this.pingHandler = handler;
    }
}

