/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.client;

import ca.uhn.fhir.parser.IParser;
import dev.dsf.fhir.client.ClientEndpoint;
import dev.dsf.fhir.client.WebsocketClient;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Session;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Base64;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.client.SslEngineConfigurator;
import org.hl7.fhir.r4.model.DomainResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketClientTyrus
implements WebsocketClient {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketClientTyrus.class);
    private final ClientManager.ReconnectHandler reconnectHandler = new ClientManager.ReconnectHandler(){

        public boolean onConnectFailure(Exception exception) {
            logger.warn("Websocket connection failed: {}", (Object)this.getMessages(exception));
            logger.debug("onConnectFailure", (Throwable)exception);
            return true;
        }

        private String getMessages(Exception e) {
            StringBuilder b = new StringBuilder();
            if (e != null) {
                if (e.getMessage() != null) {
                    b.append(e.getMessage());
                }
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (cause.getMessage() == null) continue;
                    b.append(' ');
                    b.append(cause.getMessage());
                }
            }
            return b.toString();
        }

        public boolean onDisconnect(CloseReason closeReason) {
            logger.debug("onDisconnect {}", (Object)closeReason.getReasonPhrase());
            return !WebsocketClientTyrus.this.closed;
        }
    };
    private final URI wsUri;
    private final SSLContext sslContext;
    private final String proxySchemeHostPort;
    private final String proxyUserName;
    private final char[] proxyPassword;
    private final ClientEndpoint endpoint;
    private ClientManager manager;
    private Session connection;
    private volatile boolean closed;

    public WebsocketClientTyrus(Runnable reconnector, URI wsUri, KeyStore trustStore, KeyStore keyStore, char[] keyStorePassword, String proxySchemeHostPort, String proxyUserName, char[] proxyPassword, String subscriptionIdPart) {
        this.wsUri = wsUri;
        this.sslContext = trustStore != null && keyStore == null && keyStorePassword == null ? SslConfigurator.newInstance().trustStore(trustStore).createSSLContext() : (trustStore != null && keyStore != null && keyStorePassword != null ? SslConfigurator.newInstance().trustStore(trustStore).keyStore(keyStore).keyStorePassword(keyStorePassword).createSSLContext() : SslConfigurator.getDefaultContext());
        this.proxySchemeHostPort = proxySchemeHostPort;
        this.proxyUserName = proxyUserName;
        this.proxyPassword = proxyPassword;
        this.endpoint = this.createClientEndpoint(reconnector, subscriptionIdPart);
    }

    private ClientEndpoint createClientEndpoint(Runnable reconnector, String subscriptionIdPart) {
        return new ClientEndpoint(() -> {
            this.disconnect();
            reconnector.run();
        }, subscriptionIdPart);
    }

    @Override
    public void connect() {
        if (this.manager != null) {
            throw new IllegalStateException("Allready connecting/connected");
        }
        this.manager = ClientManager.createClient();
        this.manager.getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", this.reconnectHandler);
        this.manager.getProperties().put("org.glassfish.tyrus.client.sslEngineConfigurator", new SslEngineConfigurator(this.sslContext));
        if (this.proxySchemeHostPort != null) {
            this.manager.getProperties().put("org.glassfish.tyrus.client.proxy", this.proxySchemeHostPort);
        }
        if (this.proxyUserName != null && this.proxyPassword != null) {
            HashMap<String, CallSite> proxyHeaders = new HashMap<String, CallSite>();
            proxyHeaders.put("Proxy-Authorization", (CallSite)((Object)("Basic " + Base64.getEncoder().encodeToString((this.proxyUserName + ":" + String.valueOf(this.proxyPassword)).getBytes(StandardCharsets.UTF_8)))));
            this.manager.getProperties().put("org.glassfish.tyrus.client.proxy.headers", proxyHeaders);
        }
        try {
            logger.debug("Connecting to websocket {} and waiting for connection", (Object)this.wsUri);
            this.connection = this.manager.connectToServer((Object)this.endpoint, this.wsUri);
        }
        catch (DeploymentException e) {
            logger.warn("Error while connecting to server", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.warn("Error while connecting to server", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void disconnect() {
        if (this.closed) {
            return;
        }
        logger.debug("Closing websocket {}", (Object)this.wsUri);
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (IOException e) {
            logger.warn("Error while closing websocket", (Throwable)e);
        }
        this.manager.shutdown();
        this.manager = null;
        this.closed = true;
    }

    @Override
    public void setDomainResourceHandler(Consumer<DomainResource> handler, Supplier<IParser> parserFactory) {
        this.endpoint.setDomainResourceHandler(handler, parserFactory);
    }

    @Override
    public void setPingHandler(Consumer<String> handler) {
        this.endpoint.setPingHandler(handler);
    }
}

