/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;

public class ValidationSupportWithCustomResources
implements IValidationSupport {
    private final FhirContext context;
    private final Map<String, StructureDefinition> structureDefinitionsByUrl = new HashMap<String, StructureDefinition>();
    private final Map<String, CodeSystem> codeSystemsByUrl = new HashMap<String, CodeSystem>();
    private final Map<String, ValueSet> valueSetsByUrl = new HashMap<String, ValueSet>();

    public ValidationSupportWithCustomResources(FhirContext context) {
        this(context, null, null, null);
    }

    public ValidationSupportWithCustomResources(FhirContext context, Collection<? extends StructureDefinition> structureDefinitions, Collection<? extends CodeSystem> codeSystems, Collection<? extends ValueSet> valueSets) {
        this.context = context;
        if (structureDefinitions != null) {
            structureDefinitions.forEach(this::addOrReplace);
        }
        if (codeSystems != null) {
            codeSystems.forEach(this::addOrReplace);
        }
        if (valueSets != null) {
            valueSets.forEach(this::addOrReplace);
        }
    }

    public FhirContext getFhirContext() {
        return this.context;
    }

    public List<IBaseResource> fetchAllConformanceResources() {
        return Stream.concat(this.codeSystemsByUrl.values().stream(), Stream.concat(this.fetchAllStructureDefinitions().stream(), this.valueSetsByUrl.values().stream())).collect(Collectors.toList());
    }

    public List<StructureDefinition> fetchAllStructureDefinitions() {
        return new ArrayList<StructureDefinition>(this.structureDefinitionsByUrl.values());
    }

    public StructureDefinition fetchStructureDefinition(String url) {
        return this.structureDefinitionsByUrl.getOrDefault(url, null);
    }

    public void addOrReplace(StructureDefinition s) {
        this.structureDefinitionsByUrl.put(s.getUrl(), s);
        this.structureDefinitionsByUrl.put(s.getUrl() + "|" + s.getVersion(), s);
    }

    public CodeSystem fetchCodeSystem(String url) {
        return this.codeSystemsByUrl.getOrDefault(url, null);
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theRootValidationSupport, String url) {
        return this.codeSystemsByUrl.containsKey(url);
    }

    public void addOrReplace(CodeSystem s) {
        this.codeSystemsByUrl.put(s.getUrl(), s);
        this.codeSystemsByUrl.put(s.getUrl() + "|" + s.getVersion(), s);
    }

    public ValueSet fetchValueSet(String url) {
        return this.valueSetsByUrl.getOrDefault(url, null);
    }

    public boolean isValueSetSupported(ValidationSupportContext theRootValidationSupport, String url) {
        return this.valueSetsByUrl.containsKey(url);
    }

    public void addOrReplace(ValueSet s) {
        this.valueSetsByUrl.put(s.getUrl(), s);
        this.valueSetsByUrl.put(s.getUrl() + "|" + s.getVersion(), s);
    }
}

