/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public interface SnapshotGenerator {
    public SnapshotWithValidationMessages generateSnapshot(StructureDefinition var1);

    public SnapshotWithValidationMessages generateSnapshot(StructureDefinition var1, String var2);

    public static class SnapshotWithValidationMessages {
        private final StructureDefinition snapshot;
        private final List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        public SnapshotWithValidationMessages(StructureDefinition snapshot, List<ValidationMessage> messages) {
            this.snapshot = snapshot;
            if (messages != null) {
                this.messages.addAll(messages);
            }
        }

        public StructureDefinition getSnapshot() {
            return this.snapshot;
        }

        public List<ValidationMessage> getMessages() {
            return Collections.unmodifiableList(this.messages);
        }
    }
}

