/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.fhir.validation.ResourceValidator;
import java.util.regex.Pattern;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;

public class ResourceValidatorImpl
implements ResourceValidator {
    private static final Pattern AT_DEFAULT_SLICE_PATTERN = Pattern.compile(".*(Questionnaire|QuestionnaireResponse).item:@default.*");
    private final FhirValidator validator;

    public ResourceValidatorImpl(FhirContext context, IValidationSupport validationSupport) {
        this.validator = this.configureValidator(context.newValidator(), validationSupport);
    }

    protected FhirValidator configureValidator(FhirValidator validator, IValidationSupport validationSupport) {
        FhirInstanceValidator instanceValidator = new FhirInstanceValidator(validationSupport);
        validator.registerValidatorModule((IValidatorModule)instanceValidator);
        return validator;
    }

    @Override
    public ValidationResult validate(Resource resource) {
        ValidationResult result = this.validator.validateWithResult((IBaseResource)resource);
        this.adaptDefaultSliceValidationErrorToWarning(result);
        return result;
    }

    private void adaptDefaultSliceValidationErrorToWarning(ValidationResult result) {
        result.getMessages().stream().filter(m -> AT_DEFAULT_SLICE_PATTERN.matcher(m.getMessage()).matches()).forEach(m -> m.setSeverity(ResultSeverityEnum.WARNING));
    }
}

