/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import dev.dsf.fhir.validation.SnapshotGenerator;
import java.util.ArrayList;
import java.util.Objects;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotGeneratorImpl
implements SnapshotGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotGeneratorImpl.class);
    private final IWorkerContext worker;

    public SnapshotGeneratorImpl(FhirContext fhirContext, IValidationSupport validationSupport) {
        this.worker = this.createWorker(fhirContext, validationSupport);
    }

    protected IWorkerContext createWorker(FhirContext context, IValidationSupport validationSupport) {
        HapiWorkerContext workerContext = new HapiWorkerContext(context, validationSupport);
        workerContext.setLocale(context.getLocalizer().getLocale());
        return workerContext;
    }

    @Override
    public SnapshotGenerator.SnapshotWithValidationMessages generateSnapshot(StructureDefinition differential) {
        return this.generateSnapshot(differential, "");
    }

    @Override
    public SnapshotGenerator.SnapshotWithValidationMessages generateSnapshot(StructureDefinition differential, String baseAbsoluteUrlPrefix) {
        Objects.requireNonNull(differential, "differential");
        logger.debug("Generating snapshot for StructureDefinition with id {}, url {}, version {}, base {}", new Object[]{differential.getIdElement().getIdPart(), differential.getUrl(), differential.getVersion(), differential.getBaseDefinition()});
        StructureDefinition base = (StructureDefinition)this.worker.fetchResource(StructureDefinition.class, differential.getBaseDefinition());
        if (base == null) {
            logger.warn("Base definition with url {} not found", (Object)differential.getBaseDefinition());
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ProfileUtilities profileUtils = new ProfileUtilities(this.worker, messages, null);
        profileUtils.generateSnapshot(base, differential, baseAbsoluteUrlPrefix, baseAbsoluteUrlPrefix, null);
        if (messages.isEmpty()) {
            logger.debug("Snapshot generated for StructureDefinition with id {}, url {}, version {}", new Object[]{differential.getIdElement().getIdPart(), differential.getUrl(), differential.getVersion()});
        } else {
            logger.warn("Snapshot generated with issues for StructureDefinition with id {}, url {}, version {}", new Object[]{differential.getIdElement().getIdPart(), differential.getUrl(), differential.getVersion()});
            messages.forEach(m -> logger.warn("Issue while generating snapshot: {} - {} - {}", new Object[]{m.getDisplay(), m.getLine(), m.getMessage()}));
        }
        return new SnapshotGenerator.SnapshotWithValidationMessages(differential, messages);
    }
}

