/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import dev.dsf.fhir.validation.ValueSetExpander;
import java.util.Objects;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.terminologies.ValueSetExpanderSimple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSetExpanderImpl
implements ValueSetExpander {
    private static final Logger logger = LoggerFactory.getLogger(ValueSetExpanderImpl.class);
    private final HapiWorkerContext workerContext;

    public ValueSetExpanderImpl(FhirContext fhirContext, IValidationSupport validationSupport) {
        this.workerContext = this.createWorkerContext(fhirContext, validationSupport);
    }

    protected HapiWorkerContext createWorkerContext(FhirContext fhirContext, IValidationSupport validationSupport) {
        HapiWorkerContext workerContext = new HapiWorkerContext(fhirContext, validationSupport);
        workerContext.setLocale(fhirContext.getLocalizer().getLocale());
        return workerContext;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet valueSet) {
        Objects.requireNonNull(valueSet, "valueSet");
        ValueSetExpanderSimple valueSetExpander = new ValueSetExpanderSimple((IWorkerContext)this.workerContext);
        logger.debug("Generating expansion for ValueSet with id {}, url {}, version {}", new Object[]{valueSet.getIdElement().getIdPart(), valueSet.getUrl(), valueSet.getVersion()});
        return valueSetExpander.expand(valueSet, null);
    }
}

