/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.validation.ValidationResult;
import dev.dsf.fhir.validation.SnapshotGenerator;
import dev.dsf.fhir.validation.SnapshotGeneratorImpl;
import dev.dsf.fhir.validation.StructureDefinitionReader;
import dev.dsf.fhir.validation.ValidationSupportWithCustomResources;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;

public class ValidationSupportRule
extends ExternalResource {
    private static final String VERSION_PATTERN_STRING1 = "#{version}";
    private static final Pattern VERSION_PATTERN1 = Pattern.compile(Pattern.quote("#{version}"));
    private static final String VERSION_PATTERN_STRING2 = "${version}";
    private static final Pattern VERSION_PATTERN2 = Pattern.compile(Pattern.quote("${version}"));
    private static final String DATE_PATTERN_STRING1 = "#{date}";
    private static final Pattern DATE_PATTERN1 = Pattern.compile(Pattern.quote("#{date}"));
    private static final String DATE_PATTERN_STRING2 = "${date}";
    private static final Pattern DATE_PATTERN2 = Pattern.compile(Pattern.quote("${date}"));
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final String version;
    private final LocalDate date;
    private final FhirContext context;
    private final IValidationSupport validationSupport;

    public ValidationSupportRule(List<String> structureDefinitions, List<String> codeSystems, List<String> valueSets) {
        this(null, structureDefinitions, codeSystems, valueSets);
    }

    public ValidationSupportRule(String version, List<String> structureDefinitions, List<String> codeSystems, List<String> valueSets) {
        this(version, LocalDate.MIN, structureDefinitions, codeSystems, valueSets);
    }

    public ValidationSupportRule(String version, LocalDate date, List<String> structureDefinitions, List<String> codeSystems, List<String> valueSets) {
        this.version = version;
        this.date = date;
        this.context = FhirContext.forR4();
        HapiLocalizer localizer = new HapiLocalizer(){

            public Locale getLocale() {
                return Locale.ROOT;
            }
        };
        this.context.setLocalizer(localizer);
        ValidationSupportWithCustomResources customValidationSupport = new ValidationSupportWithCustomResources(this.context);
        this.validationSupport = new ValidationSupportChain(new IValidationSupport[]{new InMemoryTerminologyServerValidationSupport(this.context), customValidationSupport, new DefaultProfileValidationSupport(this.context), new CommonCodeSystemsTerminologyService(this.context)});
        ValidationSupportRule.readProfilesAndGenerateSnapshots(this.context, version, date, customValidationSupport, new SnapshotGeneratorImpl(this.context, this.validationSupport), structureDefinitions.stream());
        ValidationSupportRule.readCodeSystems(this.context, version, date, customValidationSupport, codeSystems.stream());
        ValidationSupportRule.readValueSets(this.context, version, date, customValidationSupport, valueSets.stream());
    }

    private static void readProfilesAndGenerateSnapshots(FhirContext context, String version, LocalDate date, ValidationSupportWithCustomResources vSupport, SnapshotGenerator snapshotGenerator, Stream<String> structureDefinitions) {
        StructureDefinitionReader reader = new StructureDefinitionReader(context, version, date);
        reader.readXmlFromClassPath(structureDefinitions.map(file -> "/fhir/StructureDefinition/" + file)).forEach(diff -> {
            SnapshotGenerator.SnapshotWithValidationMessages snapshotWithValidationMessages = snapshotGenerator.generateSnapshot((StructureDefinition)diff);
            Assert.assertTrue((boolean)snapshotWithValidationMessages.getMessages().isEmpty());
            Assert.assertNotNull((Object)snapshotWithValidationMessages.getSnapshot());
            vSupport.addOrReplace(snapshotWithValidationMessages.getSnapshot());
        });
    }

    private static void readCodeSystems(FhirContext context, String version, LocalDate date, ValidationSupportWithCustomResources vSupport, Stream<String> codeSystems) {
        codeSystems.map(file -> "/fhir/CodeSystem/" + file).forEach(file -> {
            CodeSystem cS = ValidationSupportRule.readCodeSystem(context, version, date, file);
            vSupport.addOrReplace(cS);
        });
    }

    private static CodeSystem readCodeSystem(FhirContext context, String version, LocalDate date, String file) {
        CodeSystem codeSystem;
        block9: {
            InputStream in = ValidationSupportRule.class.getResourceAsStream(file);
            try {
                if (in == null) {
                    throw new IOException("File " + file + " not found");
                }
                String read = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                read = ValidationSupportRule.replaceVersionAndDate(read, version, date);
                codeSystem = (CodeSystem)context.newXmlParser().parseResource(CodeSystem.class, read);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return codeSystem;
    }

    private static void readValueSets(FhirContext context, String version, LocalDate date, ValidationSupportWithCustomResources vSupport, Stream<String> valueSets) {
        valueSets.map(file -> "/fhir/ValueSet/" + file).forEach(file -> {
            ValueSet vS = ValidationSupportRule.readValueSet(context, version, date, file);
            vSupport.addOrReplace(vS);
        });
    }

    private static ValueSet readValueSet(FhirContext context, String version, LocalDate date, String file) {
        ValueSet valueSet;
        block9: {
            InputStream in = ValidationSupportRule.class.getResourceAsStream(file);
            try {
                if (in == null) {
                    throw new IOException("File " + file + " not found");
                }
                String read = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                read = ValidationSupportRule.replaceVersionAndDate(read, version, date);
                valueSet = (ValueSet)context.newXmlParser().parseResource(ValueSet.class, read);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return valueSet;
    }

    public FhirContext getFhirContext() {
        return this.context;
    }

    public IValidationSupport getValidationSupport() {
        return this.validationSupport;
    }

    public static void logValidationMessages(Logger logger, ValidationResult result) {
        result.getMessages().stream().map(m -> m.getLocationString() + " " + m.getLocationLine() + ":" + m.getLocationCol() + " - " + m.getSeverity() + ": " + m.getMessage()).forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private static String replaceVersionAndDate(String read, String version, LocalDate date) {
        read = VERSION_PATTERN1.matcher(read).replaceAll(version);
        read = VERSION_PATTERN2.matcher(read).replaceAll(version);
        if (date != null && !LocalDate.MIN.equals(date)) {
            String dateValue = date.format(DATE_FORMAT);
            read = DATE_PATTERN1.matcher(read).replaceAll(dateValue);
            read = DATE_PATTERN2.matcher(read).replaceAll(dateValue);
        }
        return read;
    }

    public ActivityDefinition readActivityDefinition(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            String read = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            read = ValidationSupportRule.replaceVersionAndDate(read, this.version, this.date);
            ActivityDefinition activityDefinition = (ActivityDefinition)this.context.newXmlParser().parseResource(ActivityDefinition.class, read);
            return activityDefinition;
        }
    }
}

