/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.r4.model.StructureDefinition;

public class StructureDefinitionReader {
    private static final String VERSION_PATTERN_STRING1 = "#{version}";
    private static final Pattern VERSION_PATTERN1 = Pattern.compile(Pattern.quote("#{version}"));
    private static final String VERSION_PATTERN_STRING2 = "${version}";
    private static final Pattern VERSION_PATTERN2 = Pattern.compile(Pattern.quote("${version}"));
    private static final String DATE_PATTERN_STRING1 = "#{date}";
    private static final Pattern DATE_PATTERN1 = Pattern.compile(Pattern.quote("#{date}"));
    private static final String DATE_PATTERN_STRING2 = "${date}";
    private static final Pattern DATE_PATTERN2 = Pattern.compile(Pattern.quote("${date}"));
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final FhirContext context;
    private final String version;
    private final LocalDate date;

    public StructureDefinitionReader(FhirContext context) {
        this(context, null);
    }

    public StructureDefinitionReader(FhirContext context, String version) {
        this(context, version, LocalDate.MIN);
    }

    public StructureDefinitionReader(FhirContext context, String version, LocalDate date) {
        this.context = context;
        this.version = version;
        this.date = date;
    }

    public List<StructureDefinition> readXml(Path ... xmlPaths) {
        return this.readXml(Arrays.asList(xmlPaths));
    }

    public List<StructureDefinition> readXml(String ... xmlOnClassPaths) {
        return this.readXmlFromClassPath(Arrays.asList(xmlOnClassPaths));
    }

    public List<StructureDefinition> readXml(List<Path> xmlPaths) {
        return this.readXml(xmlPaths.stream()).collect(Collectors.toList());
    }

    public List<StructureDefinition> readXmlFromClassPath(List<String> xmlOnClassPaths) {
        return this.readXmlFromClassPath(xmlOnClassPaths.stream()).collect(Collectors.toList());
    }

    public Stream<StructureDefinition> readXml(Stream<Path> xmlPaths) {
        return xmlPaths.map(this::readXml);
    }

    public Stream<StructureDefinition> readXmlFromClassPath(Stream<String> xmlOnClassPaths) {
        return xmlOnClassPaths.map(this::readXml);
    }

    public StructureDefinition readXml(Path xmlPath) {
        return this.version == null ? this.doReadXml(xmlPath) : this.doReadXmlAndReplaceVersion(xmlPath, this.version, this.date);
    }

    private StructureDefinition doReadXml(Path xmlPath) {
        StructureDefinition structureDefinition;
        block8: {
            InputStream in = Files.newInputStream(xmlPath, new OpenOption[0]);
            try {
                structureDefinition = (StructureDefinition)this.context.newXmlParser().parseResource(StructureDefinition.class, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DataFormatException | IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return structureDefinition;
    }

    private StructureDefinition doReadXmlAndReplaceVersion(Path xmlPath, String version, LocalDate date) {
        StructureDefinition structureDefinition;
        block8: {
            InputStream in = Files.newInputStream(xmlPath, new OpenOption[0]);
            try {
                String read = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                read = this.replaceVersionAndDate(read, version, date);
                structureDefinition = (StructureDefinition)this.context.newXmlParser().parseResource(StructureDefinition.class, read);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return structureDefinition;
    }

    private String replaceVersionAndDate(String read, String version, LocalDate date) {
        read = VERSION_PATTERN1.matcher(read).replaceAll(version);
        read = VERSION_PATTERN2.matcher(read).replaceAll(version);
        if (date != null && !LocalDate.MIN.equals(date)) {
            String dateValue = date.format(DATE_FORMAT);
            read = DATE_PATTERN1.matcher(read).replaceAll(dateValue);
            read = DATE_PATTERN2.matcher(read).replaceAll(dateValue);
        }
        return read;
    }

    public StructureDefinition readXml(String xmlOnClassPath) {
        return this.version == null ? this.doReadXml(xmlOnClassPath) : this.doReadXmlAndReplaceVersion(xmlOnClassPath, this.version, this.date);
    }

    private StructureDefinition doReadXml(String xmlOnClassPath) {
        StructureDefinition structureDefinition;
        block8: {
            InputStream in = StructureDefinitionReader.class.getResourceAsStream(xmlOnClassPath);
            try {
                structureDefinition = (StructureDefinition)this.context.newXmlParser().parseResource(StructureDefinition.class, in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DataFormatException | IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return structureDefinition;
    }

    private StructureDefinition doReadXmlAndReplaceVersion(String xmlOnClassPath, String version, LocalDate date) {
        StructureDefinition structureDefinition;
        block8: {
            InputStream in = StructureDefinitionReader.class.getResourceAsStream(xmlOnClassPath);
            try {
                String read = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                read = this.replaceVersionAndDate(read, version, date);
                structureDefinition = (StructureDefinition)this.context.newXmlParser().parseResource(StructureDefinition.class, read);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return structureDefinition;
    }
}

