/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.secure;

import dev.dsf.fhir.authorization.AuthorizationRule;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.webservice.secure.AbstractServiceSecure;
import dev.dsf.fhir.webservice.specification.RootService;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootServiceSecure
extends AbstractServiceSecure<RootService>
implements RootService {
    private static final Logger logger = LoggerFactory.getLogger(RootServiceSecure.class);
    private final AuthorizationRule<Resource> authorizationRule;

    public RootServiceSecure(RootService delegate, String serverBase, ResponseGenerator responseGenerator, ReferenceResolver referenceResolver, AuthorizationRule<Resource> authorizationRule) {
        super(delegate, serverBase, responseGenerator, referenceResolver);
        this.authorizationRule = authorizationRule;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.authorizationRule, "authorizationRule");
    }

    @Override
    public Response root(UriInfo uri, HttpHeaders headers) {
        return ((RootService)this.delegate).root(uri, headers);
    }

    @Override
    public Response handleBundle(Bundle bundle, UriInfo uri, HttpHeaders headers) {
        Optional<String> reasonHandleBundleAllowed = this.reasonHandleBundleAllowed(bundle);
        if (reasonHandleBundleAllowed.isEmpty()) {
            audit.info("Handling of transaction and batch bundles denied for identity '{}'", (Object)this.getCurrentIdentity().getName());
            return this.forbidden("bundle");
        }
        audit.info("Handling of transaction or batch bundle allowed for identity '{}': {}", (Object)this.getCurrentIdentity().getName(), (Object)reasonHandleBundleAllowed.get());
        return ((RootService)this.delegate).handleBundle(bundle, uri, headers);
    }

    private Optional<String> reasonHandleBundleAllowed(Bundle bundle) {
        if (Bundle.BundleType.BATCH.equals((Object)bundle.getType()) || Bundle.BundleType.TRANSACTION.equals((Object)bundle.getType())) {
            logger.info("Handling of batch or transaction bundles generaly allowed for all, entries will be individualy evaluated");
            return Optional.of("Allowed for all, entries individualy evaluated");
        }
        logger.warn("Handling bundle denied, not a batch or transaction bundle");
        return Optional.empty();
    }

    @Override
    public Response history(UriInfo uri, HttpHeaders headers) {
        Optional<String> reasonHistoryAllowed = this.authorizationRule.reasonHistoryAllowed(this.getCurrentIdentity());
        if (reasonHistoryAllowed.isEmpty()) {
            audit.info("Root History denied for user '{}'", (Object)this.getCurrentIdentity().getName());
            return this.forbidden("history");
        }
        audit.info("Root History allowed for user '{}': {}", (Object)this.getCurrentIdentity().getName(), (Object)reasonHistoryAllowed.get());
        return ((RootService)this.delegate).history(uri, headers);
    }
}

