/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.webservice.impl;

import dev.dsf.fhir.authorization.AuthorizationRuleProvider;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.event.EventGenerator;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.help.ExceptionHandler;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.history.HistoryService;
import dev.dsf.fhir.search.PageAndCount;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.validation.ResourceValidator;
import dev.dsf.fhir.validation.SnapshotGenerator;
import dev.dsf.fhir.webservice.impl.AbstractResourceServiceImpl;
import dev.dsf.fhir.webservice.specification.StructureDefinitionService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureDefinitionServiceImpl
extends AbstractResourceServiceImpl<StructureDefinitionDao, StructureDefinition>
implements StructureDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(StructureDefinitionServiceImpl.class);
    private final StructureDefinitionDao snapshotDao;
    private final SnapshotGenerator snapshotGenerator;

    public StructureDefinitionServiceImpl(String path, String serverBase, int defaultPageCount, StructureDefinitionDao dao, ResourceValidator validator, EventHandler eventHandler, ExceptionHandler exceptionHandler, EventGenerator eventGenerator, ResponseGenerator responseGenerator, ParameterConverter parameterConverter, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver, ReferenceCleaner referenceCleaner, AuthorizationRuleProvider authorizationRuleProvider, StructureDefinitionDao structureDefinitionSnapshotDao, SnapshotGenerator sanapshotGenerator, HistoryService historyService) {
        super(path, StructureDefinition.class, serverBase, defaultPageCount, dao, validator, eventHandler, exceptionHandler, eventGenerator, responseGenerator, parameterConverter, referenceExtractor, referenceResolver, referenceCleaner, authorizationRuleProvider, historyService);
        this.snapshotDao = structureDefinitionSnapshotDao;
        this.snapshotGenerator = sanapshotGenerator;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.snapshotGenerator, "snapshotGenerator");
    }

    @Override
    protected Consumer<StructureDefinition> preCreate(StructureDefinition resource) throws WebApplicationException {
        StructureDefinition forPost = resource.hasSnapshot() ? resource.copy() : null;
        resource.setSnapshot(null);
        return this.postCreate(forPost);
    }

    @Override
    protected Consumer<StructureDefinition> preUpdate(StructureDefinition resource) {
        StructureDefinition forPost = resource.hasSnapshot() ? resource.copy() : null;
        resource.setSnapshot(null);
        return this.postUpdate(forPost);
    }

    private Consumer<StructureDefinition> postCreate(StructureDefinition preResource) {
        return postResource -> {
            if (preResource != null && preResource.hasSnapshot()) {
                this.exceptionHandler.catchAndLogSqlAndResourceNotFoundException(this.resourceTypeName, () -> this.snapshotDao.createWithId(preResource, this.parameterConverter.toUuid(this.resourceTypeName, postResource.getIdElement().getIdPart())));
            } else if (postResource != null) {
                try {
                    SnapshotGenerator.SnapshotWithValidationMessages s = this.snapshotGenerator.generateSnapshot(postResource);
                    if (s != null && s.getSnapshot() != null && s.getMessages().isEmpty()) {
                        this.exceptionHandler.catchAndLogSqlAndResourceNotFoundException(this.resourceTypeName, () -> this.snapshotDao.createWithId(postResource, this.parameterConverter.toUuid(this.resourceTypeName, postResource.getIdElement().getIdPart())));
                    }
                }
                catch (Exception e) {
                    logger.debug("Error while generating snapshot for StructureDefinition with id {}", (Object)postResource.getIdElement().getIdPart(), (Object)e);
                    logger.warn("Error while generating snapshot for StructureDefinition with id {}: {} - {}", new Object[]{postResource.getIdElement().getIdPart(), e.getClass().getName(), e.getMessage()});
                }
            }
        };
    }

    private Consumer<StructureDefinition> postUpdate(StructureDefinition preResource) {
        return postResource -> {
            if (preResource != null && preResource.hasSnapshot()) {
                if (postResource != null) {
                    preResource.setIdElement(postResource.getIdElement().copy());
                }
                this.exceptionHandler.catchAndLogSqlAndResourceNotFoundException(this.resourceTypeName, () -> this.snapshotDao.update(preResource));
            } else if (postResource != null) {
                try {
                    SnapshotGenerator.SnapshotWithValidationMessages s = this.snapshotGenerator.generateSnapshot(postResource);
                    if (s != null && s.getSnapshot() != null && s.getMessages().isEmpty()) {
                        this.exceptionHandler.catchAndLogSqlAndResourceNotFoundException(this.resourceTypeName, () -> this.snapshotDao.update(s.getSnapshot()));
                    }
                }
                catch (Exception e) {
                    logger.debug("Error while generating snapshot for StructureDefinition with id {}", (Object)postResource.getIdElement().getIdPart(), (Object)e);
                    logger.warn("Error while generating snapshot for StructureDefinition with id {}: {} - {}", new Object[]{postResource.getIdElement().getIdPart(), e.getClass().getName(), e.getMessage()});
                }
            }
        };
    }

    @Override
    protected Consumer<String> preDelete(String id) {
        return this::afterDelete;
    }

    private void afterDelete(String id) {
        this.exceptionHandler.catchAndLogSqlAndResourceNotFoundException(this.resourceTypeName, () -> this.snapshotDao.delete(this.parameterConverter.toUuid(this.resourceTypeName, id)));
    }

    @Override
    public Response postSnapshotNew(String snapshotPath, Parameters parameters, UriInfo uri, HttpHeaders headers) {
        Type urlType = parameters.getParameter("url");
        Optional<Parameters.ParametersParameterComponent> resource = parameters.getParameter().stream().filter(p -> "resource".equals(p.getName())).findFirst();
        if (urlType != null && resource.isEmpty()) {
            if (!(urlType instanceof StringType) && !(urlType instanceof UriType)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            PrimitiveType url = (PrimitiveType)urlType;
            logger.trace("Parameters with url {}", url.getValue());
            return this.getSnapshot((String)url.getValue(), uri, headers);
        }
        if (urlType == null && resource.isPresent() && resource.get().getResource() != null) {
            if (!(resource.get().getResource() instanceof StructureDefinition)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            StructureDefinition sd = (StructureDefinition)resource.get().getResource();
            logger.trace("Parameters with StructureDefinition resource url {}", (Object)sd.getUrl());
            if (!sd.hasDifferential()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (sd.hasSnapshot()) {
                return this.responseGenerator.response(Response.Status.OK, (Resource)sd, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
            }
            return this.responseGenerator.response(Response.Status.OK, (Resource)this.generateSnapshot(sd), this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private Response getSnapshot(String url, UriInfo uri, HttpHeaders headers) {
        SearchQuery query = this.snapshotDao.createSearchQuery(this.getCurrentIdentity(), PageAndCount.single());
        HashMap<String, List<String>> searchParameters = new HashMap<String, List<String>>();
        searchParameters.put("url", Collections.singletonList(url));
        searchParameters.put("_sort", Collections.singletonList("-_lastUpdated"));
        query.configureParameters(searchParameters);
        PartialResult result = this.exceptionHandler.handleSqlException(() -> this.snapshotDao.search(query));
        Optional<Object> snapshot = Optional.ofNullable(result.getPartialResult().isEmpty() ? null : (StructureDefinition)result.getPartialResult().get(0));
        return snapshot.map(d -> this.responseGenerator.response(Response.Status.OK, (Resource)d, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers))).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    @Override
    public Response getSnapshotNew(String snapshotPath, UriInfo uri, HttpHeaders headers) {
        return this.getSnapshot((String)uri.getQueryParameters().getFirst((Object)"url"), uri, headers);
    }

    @Override
    public Response postSnapshotExisting(String snapshotPath, String id, UriInfo uri, HttpHeaders headers) {
        return this.getSnapshotExisting(snapshotPath, id, uri, headers);
    }

    @Override
    public Response getSnapshotExisting(String snapshotPath, String id, UriInfo uri, HttpHeaders headers) {
        Optional snapshot = this.exceptionHandler.catchAndLogSqlAndResourceDeletedExceptionAndIfReturn(() -> this.snapshotDao.read(this.parameterConverter.toUuid(this.resourceTypeName, id)), Optional::empty, Optional::empty);
        if (snapshot.isPresent()) {
            return snapshot.map(d -> this.responseGenerator.response(Response.Status.OK, (Resource)d, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers))).get().build();
        }
        Optional differential = this.exceptionHandler.handleSqlAndResourceDeletedException(this.serverBase, this.resourceTypeName, () -> ((StructureDefinitionDao)this.dao).read(this.parameterConverter.toUuid(this.resourceTypeName, id)));
        return differential.map(this::generateSnapshot).map(d -> this.responseGenerator.response(Response.Status.OK, (Resource)d, this.parameterConverter.getMediaTypeThrowIfNotSupported(uri, headers))).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    private StructureDefinition generateSnapshot(StructureDefinition differential) {
        SnapshotGenerator.SnapshotWithValidationMessages snapshot = this.snapshotGenerator.generateSnapshot(differential);
        if (snapshot.getMessages().isEmpty()) {
            return snapshot.getSnapshot();
        }
        OperationOutcome outcome = new OperationOutcome();
        List issues = snapshot.getMessages().stream().map(vm -> new OperationOutcome.OperationOutcomeIssueComponent().setSeverity(OperationOutcome.IssueSeverity.ERROR).setCode(OperationOutcome.IssueType.STRUCTURE).setDiagnostics(vm.getMessage())).collect(Collectors.toList());
        outcome.setIssue(issues);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)outcome).build());
    }
}

