/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceCleanerImpl;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceExtractorImpl;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ReferenceResolverImpl;
import dev.dsf.fhir.spring.config.ClientConfig;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ReferenceConfig {
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private ClientConfig clientConfig;

    @Bean
    public ReferenceExtractor referenceExtractor() {
        return new ReferenceExtractorImpl();
    }

    @Bean
    public ReferenceResolver referenceResolver() {
        return new ReferenceResolverImpl(this.propertiesConfig.getServerBaseUrl(), this.daoConfig.daoProvider(), this.helperConfig.responseGenerator(), this.helperConfig.exceptionHandler(), this.clientConfig.clientProvider(), this.helperConfig.parameterConverter());
    }

    @Bean
    public ReferenceCleaner referenceCleaner() {
        return new ReferenceCleanerImpl(this.referenceExtractor());
    }
}

