/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.common.db.DataSourceWithLogger;
import dev.dsf.fhir.dao.ActivityDefinitionDao;
import dev.dsf.fhir.dao.BinaryDao;
import dev.dsf.fhir.dao.BundleDao;
import dev.dsf.fhir.dao.CodeSystemDao;
import dev.dsf.fhir.dao.DocumentReferenceDao;
import dev.dsf.fhir.dao.EndpointDao;
import dev.dsf.fhir.dao.GroupDao;
import dev.dsf.fhir.dao.HealthcareServiceDao;
import dev.dsf.fhir.dao.HistoryDao;
import dev.dsf.fhir.dao.LibraryDao;
import dev.dsf.fhir.dao.LocationDao;
import dev.dsf.fhir.dao.MeasureDao;
import dev.dsf.fhir.dao.MeasureReportDao;
import dev.dsf.fhir.dao.NamingSystemDao;
import dev.dsf.fhir.dao.OrganizationAffiliationDao;
import dev.dsf.fhir.dao.OrganizationDao;
import dev.dsf.fhir.dao.PatientDao;
import dev.dsf.fhir.dao.PractitionerDao;
import dev.dsf.fhir.dao.PractitionerRoleDao;
import dev.dsf.fhir.dao.ProvenanceDao;
import dev.dsf.fhir.dao.QuestionnaireDao;
import dev.dsf.fhir.dao.QuestionnaireResponseDao;
import dev.dsf.fhir.dao.ReadAccessDao;
import dev.dsf.fhir.dao.ResearchStudyDao;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.dao.SubscriptionDao;
import dev.dsf.fhir.dao.TaskDao;
import dev.dsf.fhir.dao.ValueSetDao;
import dev.dsf.fhir.dao.jdbc.ActivityDefinitionDaoJdbc;
import dev.dsf.fhir.dao.jdbc.BinaryDaoJdbc;
import dev.dsf.fhir.dao.jdbc.BundleDaoJdbc;
import dev.dsf.fhir.dao.jdbc.CodeSystemDaoJdbc;
import dev.dsf.fhir.dao.jdbc.DocumentReferenceDaoJdbc;
import dev.dsf.fhir.dao.jdbc.EndpointDaoJdbc;
import dev.dsf.fhir.dao.jdbc.GroupDaoJdbc;
import dev.dsf.fhir.dao.jdbc.HealthcareServiceDaoJdbc;
import dev.dsf.fhir.dao.jdbc.HistroyDaoJdbc;
import dev.dsf.fhir.dao.jdbc.LibraryDaoJdbc;
import dev.dsf.fhir.dao.jdbc.LocationDaoJdbc;
import dev.dsf.fhir.dao.jdbc.MeasureDaoJdbc;
import dev.dsf.fhir.dao.jdbc.MeasureReportDaoJdbc;
import dev.dsf.fhir.dao.jdbc.NamingSystemDaoJdbc;
import dev.dsf.fhir.dao.jdbc.OrganizationAffiliationDaoJdbc;
import dev.dsf.fhir.dao.jdbc.OrganizationDaoJdbc;
import dev.dsf.fhir.dao.jdbc.PatientDaoJdbc;
import dev.dsf.fhir.dao.jdbc.PractitionerDaoJdbc;
import dev.dsf.fhir.dao.jdbc.PractitionerRoleDaoJdbc;
import dev.dsf.fhir.dao.jdbc.ProvenanceDaoJdbc;
import dev.dsf.fhir.dao.jdbc.QuestionnaireDaoJdbc;
import dev.dsf.fhir.dao.jdbc.QuestionnaireResponseDaoJdbc;
import dev.dsf.fhir.dao.jdbc.ReadAccessDaoJdbc;
import dev.dsf.fhir.dao.jdbc.ResearchStudyDaoJdbc;
import dev.dsf.fhir.dao.jdbc.StructureDefinitionDaoJdbc;
import dev.dsf.fhir.dao.jdbc.StructureDefinitionSnapshotDaoJdbc;
import dev.dsf.fhir.dao.jdbc.SubscriptionDaoJdbc;
import dev.dsf.fhir.dao.jdbc.TaskDaoJdbc;
import dev.dsf.fhir.dao.jdbc.ValueSetDaoJdbc;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.dao.provider.DaoProviderImpl;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.postgresql.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DaoConfig {
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private FhirConfig fhirConfig;

    @Bean
    public DataSource dataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(Driver.class.getName());
        dataSource.setUrl(this.propertiesConfig.getDbUrl());
        dataSource.setUsername(this.propertiesConfig.getDbUsername());
        dataSource.setPassword(this.toString(this.propertiesConfig.getDbPassword()));
        dataSource.setDefaultReadOnly(Boolean.valueOf(true));
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return new DataSourceWithLogger(this.propertiesConfig.getDebugLogMessageDbStatement(), dataSource);
    }

    @Bean
    public DataSource permanentDeleteDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(Driver.class.getName());
        dataSource.setUrl(this.propertiesConfig.getDbUrl());
        dataSource.setUsername(this.propertiesConfig.getDbPermanentDeleteUsername());
        dataSource.setPassword(this.toString(this.propertiesConfig.getDbPermanentDeletePassword()));
        dataSource.setDefaultReadOnly(Boolean.valueOf(true));
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return new DataSourceWithLogger(this.propertiesConfig.getDebugLogMessageDbStatement(), dataSource);
    }

    private String toString(char[] password) {
        return password == null ? null : String.valueOf(password);
    }

    @Bean
    public ActivityDefinitionDao activityDefinitionDao() {
        return new ActivityDefinitionDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public BinaryDao binaryDao() {
        return new BinaryDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public BundleDao bundleDao() {
        return new BundleDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public CodeSystemDao codeSystemDao() {
        return new CodeSystemDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public DocumentReferenceDao documentReferenceDao() {
        return new DocumentReferenceDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public EndpointDao endpointDao() {
        return new EndpointDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public GroupDao groupDao() {
        return new GroupDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public HealthcareServiceDao healthcareServiceDao() {
        return new HealthcareServiceDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public LibraryDao libraryDao() {
        return new LibraryDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public LocationDao locationDao() {
        return new LocationDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public MeasureDao measureDao() {
        return new MeasureDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public MeasureReportDao measureReportDao() {
        return new MeasureReportDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public NamingSystemDao namingSystemDao() {
        return new NamingSystemDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public OrganizationDao organizationDao() {
        return new OrganizationDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public OrganizationAffiliationDao organizationAffiliationDao() {
        return new OrganizationAffiliationDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public PatientDao patientDao() {
        return new PatientDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public PractitionerDao practitionerDao() {
        return new PractitionerDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public PractitionerRoleDao practitionerRoleDao() {
        return new PractitionerRoleDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public ProvenanceDao provenanceDao() {
        return new ProvenanceDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public QuestionnaireDao questionnaireDao() {
        return new QuestionnaireDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public QuestionnaireResponseDao questionnaireResponseDao() {
        return new QuestionnaireResponseDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public ResearchStudyDao researchStudyDao() {
        return new ResearchStudyDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public StructureDefinitionDao structureDefinitionDao() {
        return new StructureDefinitionDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public StructureDefinitionDao structureDefinitionSnapshotDao() {
        return new StructureDefinitionSnapshotDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public SubscriptionDao subscriptionDao() {
        return new SubscriptionDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public TaskDao taskDao() {
        return new TaskDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public ValueSetDao valueSetDao() {
        return new ValueSetDaoJdbc(this.dataSource(), this.permanentDeleteDataSource(), this.fhirConfig.fhirContext());
    }

    @Bean
    public DaoProvider daoProvider() {
        return new DaoProviderImpl(this.dataSource(), this.activityDefinitionDao(), this.binaryDao(), this.bundleDao(), this.codeSystemDao(), this.documentReferenceDao(), this.endpointDao(), this.groupDao(), this.healthcareServiceDao(), this.libraryDao(), this.locationDao(), this.measureDao(), this.measureReportDao(), this.namingSystemDao(), this.organizationDao(), this.organizationAffiliationDao(), this.patientDao(), this.practitionerDao(), this.practitionerRoleDao(), this.provenanceDao(), this.questionnaireDao(), this.questionnaireResponseDao(), this.researchStudyDao(), this.structureDefinitionDao(), this.structureDefinitionSnapshotDao(), this.subscriptionDao(), this.taskDao(), this.valueSetDao(), this.readAccessDao());
    }

    @Bean
    public HistoryDao historyDao() {
        return new HistroyDaoJdbc(this.dataSource(), this.fhirConfig.fhirContext(), (BinaryDaoJdbc)this.binaryDao());
    }

    @Bean
    public ReadAccessDao readAccessDao() {
        return new ReadAccessDaoJdbc(this.dataSource());
    }
}

