/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import ca.uhn.fhir.context.support.IValidationSupport;
import dev.dsf.fhir.dao.command.CommandFactory;
import dev.dsf.fhir.dao.command.CommandFactoryImpl;
import dev.dsf.fhir.dao.command.TransactionEventHandler;
import dev.dsf.fhir.dao.command.TransactionResources;
import dev.dsf.fhir.dao.command.ValidationHelperImpl;
import dev.dsf.fhir.event.EventHandler;
import dev.dsf.fhir.spring.config.AuthorizationConfig;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.EventConfig;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import dev.dsf.fhir.spring.config.ReferenceConfig;
import dev.dsf.fhir.spring.config.SnapshotConfig;
import dev.dsf.fhir.spring.config.ValidationConfig;
import dev.dsf.fhir.validation.ResourceValidator;
import dev.dsf.fhir.validation.ResourceValidatorImpl;
import dev.dsf.fhir.validation.SnapshotGenerator;
import dev.dsf.fhir.validation.SnapshotGeneratorImpl;
import java.sql.Connection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class CommandConfig {
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private EventConfig eventConfig;
    @Autowired
    private ReferenceConfig referenceConfig;
    @Autowired
    private SnapshotConfig snapshotConfig;
    @Autowired
    private AuthorizationConfig authorizationConfig;
    @Autowired
    private ValidationConfig validationConfig;
    @Autowired
    private FhirConfig fhirConfig;

    @Bean
    public CommandFactory commandFactory() {
        return new CommandFactoryImpl(this.propertiesConfig.getServerBaseUrl(), this.propertiesConfig.getDefaultPageCount(), this.daoConfig.dataSource(), this.daoConfig.daoProvider(), this.referenceConfig.referenceExtractor(), this.referenceConfig.referenceResolver(), this.referenceConfig.referenceCleaner(), this.helperConfig.responseGenerator(), this.helperConfig.exceptionHandler(), this.helperConfig.parameterConverter(), this.eventConfig.eventManager(), this.eventConfig.eventGenerator(), this.authorizationConfig.authorizationHelper(), this.validationConfig.validationHelper(), this.snapshotConfig.snapshotGenerator(), this::transactionResourceFactory);
    }

    @Bean
    @Scope(value="prototype")
    public TransactionResources transactionResourceFactory(Connection connection) {
        EventHandler h;
        IValidationSupport validationSupport = this.validationConfig.validationSupportWithTransaction(connection);
        ValidationHelperImpl validationHelper = new ValidationHelperImpl((ResourceValidator)new ResourceValidatorImpl(this.fhirConfig.fhirContext(), validationSupport), this.helperConfig.responseGenerator());
        SnapshotGeneratorImpl snapshotGenerator = new SnapshotGeneratorImpl(this.fhirConfig.fhirContext(), validationSupport);
        TransactionEventHandler transactionEventHandler = new TransactionEventHandler(this.eventConfig.eventManager(), validationSupport instanceof EventHandler ? (h = (EventHandler)validationSupport) : null);
        return new TransactionResources(validationHelper, (SnapshotGenerator)snapshotGenerator, transactionEventHandler);
    }
}

