/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.common.auth.conf.IdentityProvider;
import dev.dsf.common.auth.conf.RoleConfig;
import dev.dsf.common.auth.conf.RoleConfigReader;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.IdentityProviderImpl;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authentication.OrganizationProviderImpl;
import dev.dsf.fhir.spring.config.DaoConfig;
import dev.dsf.fhir.spring.config.HelperConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthenticationConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationConfig.class);
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private HelperConfig helperConfig;
    @Autowired
    private PropertiesConfig propertiesConfig;

    @Bean
    public OrganizationProvider organizationProvider() {
        return new OrganizationProviderImpl(this.daoConfig.organizationDao(), this.helperConfig.exceptionHandler(), this.propertiesConfig.getOrganizationIdentifierValue());
    }

    @Bean
    public IdentityProvider identityProvider() {
        return new IdentityProviderImpl(this.roleConfig(), this.organizationProvider(), this.propertiesConfig.getOrganizationIdentifierValue());
    }

    @Bean
    public RoleConfig roleConfig() {
        RoleConfig config = new RoleConfigReader().read(this.propertiesConfig.getRoleConfig(), role -> FhirServerRole.isValid(role) ? FhirServerRole.valueOf(role) : null, this::practionerRoleFactory);
        logger.info("Role config: {}", (Object)config.toString());
        return config;
    }

    private Coding practionerRoleFactory(String role) {
        String[] roleParts;
        if (role != null && (roleParts = role.split("\\|")).length == 2) {
            return new Coding().setSystem(roleParts[0]).setCode(roleParts[1]);
        }
        return null;
    }
}

