/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.spring.config;

import dev.dsf.fhir.adapter.FhirAdapter;
import dev.dsf.fhir.adapter.ResourceActivityDefinition;
import dev.dsf.fhir.adapter.ResourceCodeSystem;
import dev.dsf.fhir.adapter.ResourceEndpoint;
import dev.dsf.fhir.adapter.ResourceLibrary;
import dev.dsf.fhir.adapter.ResourceMeasure;
import dev.dsf.fhir.adapter.ResourceMeasureReport;
import dev.dsf.fhir.adapter.ResourceNamingSystem;
import dev.dsf.fhir.adapter.ResourceOrganization;
import dev.dsf.fhir.adapter.ResourceOrganizationAffiliation;
import dev.dsf.fhir.adapter.ResourceQuestionnaire;
import dev.dsf.fhir.adapter.ResourceQuestionnaireResponse;
import dev.dsf.fhir.adapter.ResourceStructureDefinition;
import dev.dsf.fhir.adapter.ResourceSubscription;
import dev.dsf.fhir.adapter.ResourceTask;
import dev.dsf.fhir.adapter.ResourceValueSet;
import dev.dsf.fhir.adapter.SearchSetActivityDefinition;
import dev.dsf.fhir.adapter.SearchSetEndpoint;
import dev.dsf.fhir.adapter.SearchSetMeasureReport;
import dev.dsf.fhir.adapter.SearchSetMetadataResource;
import dev.dsf.fhir.adapter.SearchSetNamingSystem;
import dev.dsf.fhir.adapter.SearchSetOrganization;
import dev.dsf.fhir.adapter.SearchSetOrganizationAffiliation;
import dev.dsf.fhir.adapter.SearchSetQuestionnaireResponse;
import dev.dsf.fhir.adapter.SearchSetSubscription;
import dev.dsf.fhir.adapter.SearchSetTask;
import dev.dsf.fhir.adapter.ThymeleafAdapter;
import dev.dsf.fhir.adapter.ThymeleafContext;
import dev.dsf.fhir.adapter.ThymeleafTemplateService;
import dev.dsf.fhir.adapter.ThymeleafTemplateServiceImpl;
import dev.dsf.fhir.spring.config.FhirConfig;
import dev.dsf.fhir.spring.config.PropertiesConfig;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdapterConfig {
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private PropertiesConfig propertiesConfig;

    @Bean
    public FhirAdapter fhirAdapter() {
        return new FhirAdapter(this.fhirConfig.fhirContext());
    }

    @Bean
    public ThymeleafTemplateService thymeleafTemplateService() {
        List<ThymeleafContext> thymeleafContexts = List.of(new ResourceActivityDefinition(), new ResourceCodeSystem(), new ResourceEndpoint(), new ResourceLibrary(), new ResourceMeasure(), new ResourceMeasureReport(this.propertiesConfig.getServerBaseUrl()), new ResourceNamingSystem(), new ResourceOrganizationAffiliation(), new ResourceOrganization(), new ResourceQuestionnaire(), new ResourceQuestionnaireResponse(), new ResourceStructureDefinition(), new ResourceSubscription(), new ResourceTask(), new ResourceValueSet(), new SearchSetActivityDefinition(this.propertiesConfig.getDefaultPageCount()), new SearchSetMetadataResource<CodeSystem>(this.propertiesConfig.getDefaultPageCount(), CodeSystem.class), new SearchSetEndpoint(this.propertiesConfig.getDefaultPageCount()), new SearchSetMetadataResource<Library>(this.propertiesConfig.getDefaultPageCount(), Library.class), new SearchSetMetadataResource<Measure>(this.propertiesConfig.getDefaultPageCount(), Measure.class), new SearchSetMeasureReport(this.propertiesConfig.getDefaultPageCount()), new SearchSetNamingSystem(this.propertiesConfig.getDefaultPageCount()), new SearchSetOrganization(this.propertiesConfig.getDefaultPageCount()), new SearchSetOrganizationAffiliation(this.propertiesConfig.getDefaultPageCount()), new SearchSetMetadataResource<Questionnaire>(this.propertiesConfig.getDefaultPageCount(), Questionnaire.class), new SearchSetQuestionnaireResponse(this.propertiesConfig.getDefaultPageCount()), new SearchSetMetadataResource<StructureDefinition>(this.propertiesConfig.getDefaultPageCount(), StructureDefinition.class), new SearchSetSubscription(this.propertiesConfig.getDefaultPageCount()), new SearchSetTask(this.propertiesConfig.getDefaultPageCount()), new SearchSetMetadataResource<ValueSet>(this.propertiesConfig.getDefaultPageCount(), ValueSet.class));
        return new ThymeleafTemplateServiceImpl(this.propertiesConfig.getServerBaseUrl(), this.propertiesConfig.getUiTheme(), this.fhirConfig.fhirContext(), thymeleafContexts, this.propertiesConfig.getStaticResourceCacheEnabled(), this.modCssExists());
    }

    private boolean modCssExists() {
        return Files.isReadable(Paths.get("ui/mod.css", new String[0]));
    }

    @Bean
    public ThymeleafAdapter thymeleafAdapter() {
        return new ThymeleafAdapter(this.thymeleafTemplateService());
    }
}

