/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractTokenParameter<R extends Resource>
extends AbstractSearchParameter<R> {
    protected TokenValueAndSearchType valueAndType;

    public static List<String> getNameModifiers() {
        return List.of(":not");
    }

    public AbstractTokenParameter(Class<R> resourceType, String parameterName) {
        super(resourceType, parameterName);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        this.valueAndType = TokenValueAndSearchType.fromParamValue(this.parameterName, queryParameterName, queryParameterValue);
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    @Override
    public final String getFilterQuery() {
        return this.valueAndType.negated ? this.getNegatedFilterQuery() : this.getPositiveFilterQuery();
    }

    protected abstract String getNegatedFilterQuery();

    protected abstract String getPositiveFilterQuery();

    @Override
    public String getBundleUriQueryParameterName() {
        return this.valueAndType.negated ? this.parameterName + ":not" : this.parameterName;
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case TokenSearchType.CODE -> this.valueAndType.codeValue;
            case TokenSearchType.CODE_AND_SYSTEM -> this.valueAndType.systemValue + "|" + this.valueAndType.codeValue;
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> "|" + this.valueAndType.codeValue;
            case TokenSearchType.SYSTEM -> this.valueAndType.systemValue + "|";
        };
    }

    protected boolean codingMatches(List<CodeableConcept> codes) {
        return codes.stream().filter(CodeableConcept::hasCoding).map(CodeableConcept::getCoding).flatMap(Collection::stream).filter(Coding::hasCode).anyMatch(this.codingMatches(this.valueAndType));
    }

    private Predicate<Coding> codingMatches(TokenValueAndSearchType valueAndType) {
        return coding -> {
            boolean bl = valueAndType.negated;
            return bl ^ (switch (valueAndType.type) {
                case TokenSearchType.CODE -> {
                    if (coding.hasCode() && Objects.equals(valueAndType.codeValue, coding.getCode())) {
                        yield true;
                    }
                    yield false;
                }
                case TokenSearchType.CODE_AND_SYSTEM -> {
                    if (coding.hasCode() && Objects.equals(valueAndType.codeValue, coding.getCode()) && coding.hasSystem() && Objects.equals(valueAndType.systemValue, coding.getSystem())) {
                        yield true;
                    }
                    yield false;
                }
                case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> {
                    if (coding.hasCode() && Objects.equals(valueAndType.codeValue, coding.getCode()) && !coding.hasSystem()) {
                        yield true;
                    }
                    yield false;
                }
                case TokenSearchType.SYSTEM -> {
                    if (coding.hasSystem() && Objects.equals(valueAndType.systemValue, coding.getSystem())) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            });
        };
    }
}

