/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.MetadataResource;

public class AbstractStatusParameter<R extends MetadataResource>
extends AbstractTokenParameter<R> {
    public static final String PARAMETER_NAME = "status";
    private final String resourceColumn;
    private Enumerations.PublicationStatus status;

    public AbstractStatusParameter(Class<R> resourceType, String resourceColumn) {
        super(resourceType, PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        super.doConfigure(errors, queryParameterName, queryParameterValue);
        if (this.valueAndType != null && this.valueAndType.type == TokenSearchType.CODE) {
            this.status = this.toStatus(errors, this.valueAndType.codeValue, queryParameterValue);
        }
    }

    private Enumerations.PublicationStatus toStatus(List<? super SearchQueryParameterError> errors, String status, String queryParameterValue) {
        if (status == null || status.isBlank()) {
            return null;
        }
        try {
            return Enumerations.PublicationStatus.fromCode((String)status);
        }
        catch (FHIRException e) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, queryParameterValue, (Exception)((Object)e)));
            return null;
        }
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && this.status != null;
    }

    @Override
    protected String getPositiveFilterQuery() {
        return this.resourceColumn + "->>'status' = ?";
    }

    @Override
    protected String getNegatedFilterQuery() {
        return this.resourceColumn + "->>'status' <> ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, this.status.toCode());
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return this.status.toCode();
    }

    @Override
    protected boolean resourceMatches(R resource) {
        return this.valueAndType.negated ^ Objects.equals(resource.getStatus(), this.status);
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return this.resourceColumn + "->>'status'" + sortDirectionWithSpacePrefix;
    }
}

