/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.BiPredicate;
import org.hl7.fhir.r4.model.Resource;

public class AbstractSingleIdentifierParameter<R extends Resource>
extends AbstractIdentifierParameter<R> {
    public AbstractSingleIdentifierParameter(Class<R> resourceType, String resourceColumn, BiPredicate<TokenValueAndSearchType, R> identifierMatches) {
        super(resourceType, resourceColumn, identifierMatches);
    }

    @Override
    protected String getPositiveFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case TokenSearchType.CODE, TokenSearchType.CODE_AND_SYSTEM, TokenSearchType.SYSTEM -> this.resourceColumn + "->'identifier' = ?::jsonb";
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> this.resourceColumn + "->'identifier'->>'value' = ? AND NOT (" + this.resourceColumn + "->'identifier' ?? 'system')";
        };
    }

    @Override
    protected String getNegatedFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case TokenSearchType.CODE, TokenSearchType.CODE_AND_SYSTEM, TokenSearchType.SYSTEM -> this.resourceColumn + "->'identifier' <> ?::jsonb";
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> this.resourceColumn + "->'identifier'->>'value' <> ? OR (" + this.resourceColumn + "->'identifier' ?? 'system')";
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case CODE: {
                statement.setString(parameterIndex, "{\"value\": \"" + this.valueAndType.codeValue + "\"}");
                return;
            }
            case CODE_AND_SYSTEM: {
                statement.setString(parameterIndex, "{\"value\": \"" + this.valueAndType.codeValue + "\", \"system\": \"" + this.valueAndType.systemValue + "\"}");
                return;
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                statement.setString(parameterIndex, this.valueAndType.codeValue);
                return;
            }
            case SYSTEM: {
                statement.setString(parameterIndex, "{\"system\": \"" + this.valueAndType.systemValue + "\"}");
                return;
            }
        }
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(" + this.resourceColumn + "->'identifier'->>'system')::text || (" + this.resourceColumn + "->'identifier'->>'value')::text" + sortDirectionWithSpacePrefix;
    }
}

