/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryIncludeParameter;
import dev.dsf.fhir.search.SearchQueryIncludeParameterConfiguration;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractReferenceParameter<R extends DomainResource>
extends AbstractSearchParameter<R>
implements SearchQueryIncludeParameter<R> {
    private static final String PARAMETER_NAME_IDENTIFIER_MODIFIER = ":identifier";
    private final List<String> targetResourceTypeNames;
    protected ReferenceValueAndSearchType valueAndType;

    public static List<String> getNameModifiers() {
        return Collections.singletonList(PARAMETER_NAME_IDENTIFIER_MODIFIER);
    }

    public AbstractReferenceParameter(Class<R> resourceType, String parameterName, String ... targetResourceTypeNames) {
        super(resourceType, parameterName);
        this.targetResourceTypeNames = Arrays.asList(targetResourceTypeNames);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        this.valueAndType = ReferenceValueAndSearchType.fromParamValue(errors, this.targetResourceTypeNames, this.parameterName, queryParameterName, queryParameterValue);
    }

    @Override
    public boolean isDefined() {
        return this.valueAndType != null;
    }

    @Override
    public String getBundleUriQueryParameterName() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case ReferenceSearchType.ID, ReferenceSearchType.URL, ReferenceSearchType.RESOURCE_NAME_AND_ID -> this.parameterName;
            case ReferenceSearchType.TYPE_AND_ID, ReferenceSearchType.TYPE_AND_RESOURCE_NAME_AND_ID -> this.parameterName + ":" + this.valueAndType.resourceName;
            case ReferenceSearchType.IDENTIFIER -> this.parameterName + PARAMETER_NAME_IDENTIFIER_MODIFIER;
        };
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case ReferenceSearchType.ID, ReferenceSearchType.TYPE_AND_ID -> this.valueAndType.id;
            case ReferenceSearchType.URL -> this.valueAndType.url;
            case ReferenceSearchType.RESOURCE_NAME_AND_ID, ReferenceSearchType.TYPE_AND_RESOURCE_NAME_AND_ID -> this.valueAndType.resourceName + "/" + this.valueAndType.id;
            case ReferenceSearchType.IDENTIFIER -> {
                switch (this.valueAndType.identifier.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CODE: {
                        yield this.valueAndType.identifier.codeValue;
                    }
                    case CODE_AND_SYSTEM: {
                        yield this.valueAndType.identifier.systemValue + "|" + this.valueAndType.identifier.codeValue;
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        yield "|" + this.valueAndType.identifier.codeValue;
                    }
                    case SYSTEM: 
                }
                yield this.valueAndType.identifier.systemValue + "|";
            }
        };
    }

    @Override
    public void resolveReferencesForMatching(Resource resource, DaoProvider daoProvider) throws SQLException {
        if (this.resourceType.isInstance(resource)) {
            this.doResolveReferencesForMatching((DomainResource)this.resourceType.cast(resource), daoProvider);
        }
    }

    protected abstract void doResolveReferencesForMatching(R var1, DaoProvider var2) throws SQLException;

    @Override
    public SearchQueryIncludeParameterConfiguration configureInclude(List<? super SearchQueryParameterError> errors, String queryParameterIncludeValue) {
        IncludeParts includeParts = IncludeParts.fromString(queryParameterIncludeValue);
        String includeSql = this.getIncludeSql(includeParts);
        if (includeSql != null) {
            return new SearchQueryIncludeParameterConfiguration(includeSql, includeParts, (resource, connection) -> this.modifyIncludeResource(includeParts, (Resource)resource, (Connection)connection));
        }
        return null;
    }

    protected abstract String getIncludeSql(IncludeParts var1);

    protected abstract void modifyIncludeResource(IncludeParts var1, Resource var2, Connection var3);

    protected static class ReferenceValueAndSearchType {
        public final String resourceName;
        public final String id;
        public final String url;
        public final TokenValueAndSearchType identifier;
        public final ReferenceSearchType type;

        private ReferenceValueAndSearchType(String resourceName, String id, String url, TokenValueAndSearchType identifier, ReferenceSearchType type) {
            this.resourceName = resourceName;
            this.id = id;
            this.url = url;
            this.type = type;
            this.identifier = identifier;
        }

        public static ReferenceValueAndSearchType fromParamValue(List<? super SearchQueryParameterError> errors, List<String> targetResourceTypeNames, String parameterName, String queryParameterName, String queryParameterValue) {
            if (parameterName.equals(queryParameterName)) {
                if (queryParameterValue.indexOf(47) == -1 && targetResourceTypeNames.size() == 1) {
                    return new ReferenceValueAndSearchType(targetResourceTypeNames.get(0), queryParameterValue, null, null, ReferenceSearchType.ID);
                }
                if (queryParameterValue.indexOf(47) == -1 && targetResourceTypeNames.size() > 1) {
                    return new ReferenceValueAndSearchType(null, queryParameterValue, null, null, ReferenceSearchType.ID);
                }
                if (queryParameterValue.startsWith("http")) {
                    return new ReferenceValueAndSearchType(null, null, queryParameterValue, null, ReferenceSearchType.URL);
                }
                if (queryParameterValue.indexOf(47) >= 0) {
                    String[] splitAtSlash = queryParameterValue.split("/");
                    if (splitAtSlash.length == 2) {
                        if (targetResourceTypeNames.stream().anyMatch(name -> name.equals(splitAtSlash[0]))) {
                            return new ReferenceValueAndSearchType(splitAtSlash[0], splitAtSlash[1], null, null, ReferenceSearchType.RESOURCE_NAME_AND_ID);
                        }
                        errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameterValue, "Unsupported target resource type name " + splitAtSlash[0] + ", not one of " + targetResourceTypeNames));
                        return null;
                    }
                    errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameterValue, "Unsupported reference " + queryParameterValue + " not 'type/id'"));
                    return null;
                }
                errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameterValue));
                return null;
            }
            if ((parameterName + AbstractReferenceParameter.PARAMETER_NAME_IDENTIFIER_MODIFIER).equals(queryParameterName)) {
                TokenValueAndSearchType identifier = TokenValueAndSearchType.fromParamValue(parameterName, queryParameterName, queryParameterValue);
                return new ReferenceValueAndSearchType(null, null, null, identifier, ReferenceSearchType.IDENTIFIER);
            }
            Optional<String> type = targetResourceTypeNames.stream().filter(t -> (parameterName + ":" + t).equals(queryParameterName)).findFirst();
            if (type.isPresent()) {
                if (queryParameterValue.indexOf(47) == -1) {
                    return new ReferenceValueAndSearchType(type.get(), queryParameterValue, null, null, ReferenceSearchType.TYPE_AND_ID);
                }
                String[] splitAtSlash = queryParameterValue.split("/");
                if (splitAtSlash.length == 2) {
                    if (type.get().equals(splitAtSlash[0])) {
                        return new ReferenceValueAndSearchType(type.get(), splitAtSlash[1], null, null, ReferenceSearchType.TYPE_AND_RESOURCE_NAME_AND_ID);
                    }
                    errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameterValue, "Inconsistent target resource type name " + type.get() + " vs. " + splitAtSlash[0]));
                    return null;
                }
                errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameterValue, "Unsupported reference " + queryParameterValue + " not 'type/id'"));
                return null;
            }
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, parameterName, queryParameterValue, "Unsupported target resource type in " + queryParameterName + " not one of " + targetResourceTypeNames));
            return null;
        }
    }

    protected static enum ReferenceSearchType {
        ID,
        TYPE_AND_ID,
        RESOURCE_NAME_AND_ID,
        TYPE_AND_RESOURCE_NAME_AND_ID,
        URL,
        IDENTIFIER;

    }
}

