/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.parameters.basic.AbstractStringParameter;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;

public class AbstractNameOrAliasParameter<R extends Resource>
extends AbstractStringParameter<R> {
    public static final String PARAMETER_NAME = "name";
    private final String resourceColumn;
    private final Predicate<R> hasName;
    private final Function<R, String> getName;
    private final Predicate<R> hasAlias;
    private final Function<R, List<StringType>> getAlias;

    public AbstractNameOrAliasParameter(Class<R> resourceType, String resourceColumn, Predicate<R> hasName, Function<R, String> getName, Predicate<R> hasAlias, Function<R, List<StringType>> getAlias) {
        super(resourceType, PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
        this.hasName = hasName;
        this.getName = getName;
        this.hasAlias = hasAlias;
        this.getAlias = getAlias;
    }

    @Override
    public String getFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractStringParameter.StringSearchType.STARTS_WITH, AbstractStringParameter.StringSearchType.CONTAINS -> "(lower(" + this.resourceColumn + "->>'name') LIKE ? OR EXISTS (SELECT 1 FROM (SELECT jsonb_array_elements_text(" + this.resourceColumn + "->'alias') AS alias) AS aliases WHERE alias LIKE ?))";
            case AbstractStringParameter.StringSearchType.EXACT -> "(" + this.resourceColumn + "->>'name' = ? OR " + this.resourceColumn + "->'alias' ?? ?)";
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 2;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case STARTS_WITH: {
                statement.setString(parameterIndex, this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case CONTAINS: {
                statement.setString(parameterIndex, "%" + this.valueAndType.value.toLowerCase() + "%");
                return;
            }
            case EXACT: {
                statement.setString(parameterIndex, this.valueAndType.value);
                return;
            }
        }
    }

    @Override
    protected boolean resourceMatches(R resource) {
        return this.hasName.test(resource) && this.nameMatches(this.getName.apply(resource)) || this.hasAlias.test(resource) && this.aliasMatches(resource);
    }

    private boolean aliasMatches(R resource) {
        return this.getAlias.apply(resource).stream().filter(PrimitiveType::hasValue).map(PrimitiveType::getValue).anyMatch(this::nameMatches);
    }

    private boolean nameMatches(String name) {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractStringParameter.StringSearchType.STARTS_WITH -> name.toLowerCase().startsWith(this.valueAndType.value.toLowerCase());
            case AbstractStringParameter.StringSearchType.CONTAINS -> name.toLowerCase().contains(this.valueAndType.value.toLowerCase());
            case AbstractStringParameter.StringSearchType.EXACT -> Objects.equals(name, this.valueAndType.value);
        };
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(SELECT array_agg(name) FROM (SELECT " + this.resourceColumn + "->>'name' AS name UNION SELECT jsonb_array_elements_text(" + this.resourceColumn + "->'alias') AS name) AS names)" + sortDirectionWithSpacePrefix;
    }
}

