/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import dev.dsf.fhir.search.parameters.basic.TokenValueAndSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractIdentifierParameter<R extends Resource>
extends AbstractTokenParameter<R> {
    public static final String PARAMETER_NAME = "identifier";
    protected final String resourceColumn;
    private final BiPredicate<TokenValueAndSearchType, R> identifierMatches;

    public AbstractIdentifierParameter(Class<R> resourceType, String resourceColumn, BiPredicate<TokenValueAndSearchType, R> identifierMatches) {
        super(resourceType, PARAMETER_NAME);
        this.resourceColumn = resourceColumn;
        this.identifierMatches = identifierMatches;
    }

    protected static <R extends Resource> BiPredicate<TokenValueAndSearchType, R> listMatcher(Predicate<R> hasIdentifier, Function<R, List<Identifier>> getIdentifiers) {
        return (v, r) -> hasIdentifier.test(r) && ((List)getIdentifiers.apply(r)).stream().anyMatch(AbstractIdentifierParameter.identifierMatches(v));
    }

    protected static <R extends Resource> BiPredicate<TokenValueAndSearchType, R> singleMatcher(Predicate<R> hasIdentifier, Function<R, Identifier> getIdentifier) {
        return (v, r) -> hasIdentifier.test(r) && AbstractIdentifierParameter.identifierMatches(v, (Identifier)getIdentifier.apply(r));
    }

    public static Predicate<Identifier> identifierMatches(TokenValueAndSearchType valueAndType) {
        return i -> AbstractIdentifierParameter.identifierMatches(valueAndType, i);
    }

    public static boolean identifierMatches(TokenValueAndSearchType valueAndType, Identifier identifier) {
        boolean bl = valueAndType.negated;
        return bl ^ (switch (valueAndType.type) {
            case TokenSearchType.CODE -> {
                if (identifier.hasValue() && Objects.equals(valueAndType.codeValue, identifier.getValue())) {
                    yield true;
                }
                yield false;
            }
            case TokenSearchType.CODE_AND_SYSTEM -> {
                if (identifier.hasValue() && Objects.equals(valueAndType.codeValue, identifier.getValue()) && identifier.hasSystem() && Objects.equals(valueAndType.systemValue, identifier.getSystem())) {
                    yield true;
                }
                yield false;
            }
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> {
                if (identifier.hasValue() && Objects.equals(valueAndType.codeValue, identifier.getValue()) && !identifier.hasSystem()) {
                    yield true;
                }
                yield false;
            }
            case TokenSearchType.SYSTEM -> Objects.equals(valueAndType.systemValue, identifier.getSystem());
            default -> false;
        });
    }

    @Override
    protected String getPositiveFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case TokenSearchType.CODE, TokenSearchType.CODE_AND_SYSTEM, TokenSearchType.SYSTEM -> this.resourceColumn + "->'identifier' @> ?::jsonb";
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> "(SELECT count(*) FROM jsonb_array_elements(" + this.resourceColumn + "->'identifier') identifier WHERE identifier->>'value' = ? AND NOT (identifier ?? 'system')) > 0";
        };
    }

    @Override
    protected String getNegatedFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case TokenSearchType.CODE, TokenSearchType.CODE_AND_SYSTEM, TokenSearchType.SYSTEM -> "NOT (" + this.resourceColumn + "->'identifier' @> ?::jsonb)";
            case TokenSearchType.CODE_AND_NO_SYSTEM_PROPERTY -> "(SELECT count(*) FROM jsonb_array_elements(" + this.resourceColumn + "->'identifier') identifier WHERE identifier->>'value' <> ? OR (identifier ?? 'system')) > 0";
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        switch (this.valueAndType.type) {
            case CODE: {
                statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.codeValue + "\"}]");
                return;
            }
            case CODE_AND_SYSTEM: {
                statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.codeValue + "\", \"system\": \"" + this.valueAndType.systemValue + "\"}]");
                return;
            }
            case CODE_AND_NO_SYSTEM_PROPERTY: {
                statement.setString(parameterIndex, this.valueAndType.codeValue);
                return;
            }
            case SYSTEM: {
                statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.systemValue + "\"}]");
                return;
            }
        }
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "(SELECT string_agg((identifier->>'system')::text || (identifier->>'value')::text, ' ') FROM jsonb_array_elements(" + this.resourceColumn + "->'identifier') identifier)" + sortDirectionWithSpacePrefix;
    }

    @Override
    protected boolean resourceMatches(R resource) {
        return this.identifierMatches.test(this.valueAndType, resource);
    }
}

