/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters.basic;

import com.google.common.base.Objects;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractSearchParameter;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.Resource;

public abstract class AbstractBooleanParameter<R extends Resource>
extends AbstractSearchParameter<R> {
    private final Predicate<R> hasBoolean;
    private final Function<R, Boolean> getBoolean;
    protected Boolean value;

    public AbstractBooleanParameter(Class<R> resourceType, String parameterName, Predicate<R> hasBoolean, Function<R, Boolean> getBoolean) {
        super(resourceType, parameterName);
        this.hasBoolean = hasBoolean;
        this.getBoolean = getBoolean;
    }

    @Override
    public void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        if (queryParameterValue != null && !queryParameterValue.isEmpty()) {
            switch (queryParameterValue) {
                case "true": {
                    this.value = true;
                    break;
                }
                case "false": {
                    this.value = false;
                    break;
                }
                default: {
                    this.value = null;
                    errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, queryParameterValue, "true or false expected"));
                }
            }
        }
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public String getBundleUriQueryParameterName() {
        return this.parameterName;
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return String.valueOf(this.value);
    }

    @Override
    protected boolean resourceMatches(R resource) {
        return this.hasBoolean.test(resource) && Objects.equal((Object)this.getBoolean.apply(resource), (Object)this.value);
    }
}

