/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.IncludeParameterDefinition;
import dev.dsf.fhir.search.IncludeParts;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractIdentifierParameter;
import dev.dsf.fhir.search.parameters.basic.AbstractReferenceParameter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;

@IncludeParameterDefinition(resourceType=Task.class, parameterName="requester", targetResourceTypes={Practitioner.class, Organization.class, Patient.class, PractitionerRole.class})
@SearchQueryParameter.SearchParameterDefinition(name="requester", definition="http://hl7.org/fhir/SearchParameter/Task-requester", type=Enumerations.SearchParamType.REFERENCE, documentation="Search by task requester")
public class TaskRequester
extends AbstractReferenceParameter<Task> {
    private static final String RESOURCE_TYPE_NAME = "Task";
    public static final String PARAMETER_NAME = "requester";
    private static final String[] TARGET_RESOURCE_TYPE_NAMES = new String[]{"Practitioner", "Organization", "Patient", "PractitionerRole"};
    private static final String IDENTIFIERS_SUBQUERY = "(SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = task->'requester'->>'reference' UNION SELECT organization->'identifier' FROM current_organizations WHERE concat('Organization/', organization->>'id') = task->'requester'->>'reference' UNION SELECT patient->'identifier' FROM current_patients WHERE concat('Patient/', patient->>'id') = task->'requester'->>'reference' UNION SELECT practitioner_role->'identifier' FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = task->'requester'->>'reference')";

    public static List<String> getIncludeParameterValues() {
        return Arrays.stream(TARGET_RESOURCE_TYPE_NAMES).map(target -> "Task:requester:" + target).toList();
    }

    public TaskRequester() {
        super(Task.class, PARAMETER_NAME, TARGET_RESOURCE_TYPE_NAMES);
    }

    @Override
    public String getFilterQuery() {
        return switch (this.valueAndType.type) {
            default -> throw new IncompatibleClassChangeError();
            case AbstractReferenceParameter.ReferenceSearchType.ID -> "task->'requester'->>'reference' = ANY (?)";
            case AbstractReferenceParameter.ReferenceSearchType.RESOURCE_NAME_AND_ID, AbstractReferenceParameter.ReferenceSearchType.URL, AbstractReferenceParameter.ReferenceSearchType.TYPE_AND_ID, AbstractReferenceParameter.ReferenceSearchType.TYPE_AND_RESOURCE_NAME_AND_ID -> "task->'requester'->>'reference' = ?";
            case AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER -> {
                switch (this.valueAndType.identifier.type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CODE: 
                    case CODE_AND_SYSTEM: 
                    case SYSTEM: {
                        yield "(SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = task->'requester'->>'reference' UNION SELECT organization->'identifier' FROM current_organizations WHERE concat('Organization/', organization->>'id') = task->'requester'->>'reference' UNION SELECT patient->'identifier' FROM current_patients WHERE concat('Patient/', patient->>'id') = task->'requester'->>'reference' UNION SELECT practitioner_role->'identifier' FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = task->'requester'->>'reference') @> ?::jsonb";
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: 
                }
                yield "(SELECT count(*) FROM jsonb_array_elements((SELECT practitioner->'identifier' FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = task->'requester'->>'reference' UNION SELECT organization->'identifier' FROM current_organizations WHERE concat('Organization/', organization->>'id') = task->'requester'->>'reference' UNION SELECT patient->'identifier' FROM current_patients WHERE concat('Patient/', patient->>'id') = task->'requester'->>'reference' UNION SELECT practitioner_role->'identifier' FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = task->'requester'->>'reference')) identifier WHERE identifier->>'value' = ? AND NOT (identifier ?? 'system')) > 0";
            }
        };
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        block0 : switch (this.valueAndType.type) {
            case ID: {
                Array array = arrayCreator.apply("TEXT", Arrays.stream(TARGET_RESOURCE_TYPE_NAMES).map(n -> n + "/" + this.valueAndType.id).toArray());
                statement.setArray(parameterIndex, array);
                break;
            }
            case RESOURCE_NAME_AND_ID: 
            case TYPE_AND_ID: 
            case TYPE_AND_RESOURCE_NAME_AND_ID: {
                statement.setString(parameterIndex, this.valueAndType.resourceName + "/" + this.valueAndType.id);
                break;
            }
            case URL: {
                statement.setString(parameterIndex, this.valueAndType.url);
                break;
            }
            case IDENTIFIER: {
                switch (this.valueAndType.identifier.type) {
                    case CODE: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_SYSTEM: {
                        statement.setString(parameterIndex, "[{\"value\": \"" + this.valueAndType.identifier.codeValue + "\", \"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                        break block0;
                    }
                    case CODE_AND_NO_SYSTEM_PROPERTY: {
                        statement.setString(parameterIndex, this.valueAndType.identifier.codeValue);
                        break block0;
                    }
                    case SYSTEM: {
                        statement.setString(parameterIndex, "[{\"system\": \"" + this.valueAndType.identifier.systemValue + "\"}]");
                    }
                }
            }
        }
    }

    @Override
    protected void doResolveReferencesForMatching(Task resource, DaoProvider daoProvider) throws SQLException {
        Reference reference = resource.getRequester();
        IIdType idType = reference.getReferenceElement();
        if (idType.hasResourceType()) {
            if ("Practitioner".equals(idType.getResourceType())) {
                this.setResource(reference, idType, daoProvider.getPractitionerDao());
            } else if ("Organization".equals(idType.getResourceType())) {
                this.setResource(reference, idType, daoProvider.getOrganizationDao());
            } else if ("Patient".equals(idType.getResourceType())) {
                this.setResource(reference, idType, daoProvider.getPatientDao());
            } else if ("PractitionerRole".equals(idType.getResourceType())) {
                this.setResource(reference, idType, daoProvider.getPractitionerRoleDao());
            }
        }
    }

    private void setResource(Reference reference, IIdType idType, ResourceDao<?> dao) throws SQLException {
        try {
            if (idType.hasVersionIdPart()) {
                dao.readVersion(UUID.fromString(idType.getIdPart()), idType.getVersionIdPartAsLong()).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            } else {
                dao.read(UUID.fromString(idType.getIdPart())).ifPresent(arg_0 -> ((Reference)reference).setResource(arg_0));
            }
        }
        catch (ResourceDeletedException resourceDeletedException) {
            // empty catch block
        }
    }

    @Override
    protected boolean resourceMatches(Task resource) {
        if (AbstractReferenceParameter.ReferenceSearchType.IDENTIFIER.equals((Object)this.valueAndType.type)) {
            IBaseResource iBaseResource = resource.getRequester().getResource();
            if (iBaseResource instanceof Practitioner) {
                Practitioner p = (Practitioner)iBaseResource;
                return p.getIdentifier().stream().anyMatch(AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier));
            }
            iBaseResource = resource.getRequester().getResource();
            if (iBaseResource instanceof Organization) {
                Organization o = (Organization)iBaseResource;
                return o.getIdentifier().stream().anyMatch(AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier));
            }
            iBaseResource = resource.getRequester().getResource();
            if (iBaseResource instanceof Patient) {
                Patient p = (Patient)iBaseResource;
                return p.getIdentifier().stream().anyMatch(AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier));
            }
            iBaseResource = resource.getRequester().getResource();
            if (iBaseResource instanceof PractitionerRole) {
                PractitionerRole p = (PractitionerRole)iBaseResource;
                return p.getIdentifier().stream().anyMatch(AbstractIdentifierParameter.identifierMatches(this.valueAndType.identifier));
            }
            return false;
        }
        String ref = resource.getRequester().getReference();
        return switch (this.valueAndType.type) {
            case AbstractReferenceParameter.ReferenceSearchType.ID -> {
                if (ref.equals("Practitioner/" + this.valueAndType.id) || ref.equals("Organization/" + this.valueAndType.id) || ref.equals("Patient/" + this.valueAndType.id) || ref.equals("PractitionerRole/" + this.valueAndType.id)) {
                    yield true;
                }
                yield false;
            }
            case AbstractReferenceParameter.ReferenceSearchType.RESOURCE_NAME_AND_ID -> ref.equals(this.valueAndType.resourceName + "/" + this.valueAndType.id);
            case AbstractReferenceParameter.ReferenceSearchType.URL -> ref.equals(this.valueAndType.url);
            default -> false;
        };
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "task->'requester'->>'reference'";
    }

    @Override
    protected String getIncludeSql(IncludeParts includeParts) {
        if (RESOURCE_TYPE_NAME.equals(includeParts.getSourceResourceTypeName()) && PARAMETER_NAME.equals(includeParts.getSearchParameterName()) && Arrays.stream(TARGET_RESOURCE_TYPE_NAMES).anyMatch(n -> n.equals(includeParts.getTargetResourceTypeName()))) {
            return switch (includeParts.getTargetResourceTypeName()) {
                case "Practitioner" -> "(SELECT jsonb_build_array(practitioner) FROM current_practitioners WHERE concat('Practitioner/', practitioner->>'id') = task->'requester'->>'reference') AS practitioners";
                case "Organization" -> "(SELECT jsonb_build_array(organization) FROM current_organizations WHERE concat('Organization/', organization->>'id') = task->'requester'->>'reference') AS organizations";
                case "Patient" -> "(SELECT jsonb_build_array(patient) FROM current_patients WHERE concat('Patient/', patient->>'id') = task->'requester'->>'reference') AS patients";
                case "PractitionerRole" -> "(SELECT jsonb_build_array(practitioner_role) FROM current_practitioner_roles WHERE concat('PractitionerRole/', practitioner_role->>'id') = task->'requester'->>'reference') AS practitioner_roles";
                default -> null;
            };
        }
        return null;
    }

    @Override
    protected void modifyIncludeResource(IncludeParts includeParts, Resource resource, Connection connection) {
    }
}

