/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Subscription;

@SearchQueryParameter.SearchParameterDefinition(name="type", definition="http://hl7.org/fhir/SearchParameter/Subscription-type", type=Enumerations.SearchParamType.TOKEN, documentation="The type of channel for the sent notifications")
public class SubscriptionType
extends AbstractTokenParameter<Subscription> {
    public static final String PARAMETER_NAME = "type";
    private Subscription.SubscriptionChannelType channelType;

    public SubscriptionType() {
        super(Subscription.class, PARAMETER_NAME);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        super.doConfigure(errors, queryParameterName, queryParameterValue);
        if (this.valueAndType != null && this.valueAndType.type == TokenSearchType.CODE) {
            this.channelType = this.toChannelType(errors, this.valueAndType.codeValue, queryParameterValue);
        }
    }

    private Subscription.SubscriptionChannelType toChannelType(List<? super SearchQueryParameterError> errors, String status, String queryParameterValue) {
        if (status == null || status.isBlank()) {
            return null;
        }
        try {
            return Subscription.SubscriptionChannelType.fromCode((String)status);
        }
        catch (FHIRException e) {
            errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, this.parameterName, queryParameterValue, (Exception)((Object)e)));
            return null;
        }
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && this.channelType != null;
    }

    @Override
    protected String getPositiveFilterQuery() {
        return "subscription->'channel'->>'type' = ?";
    }

    @Override
    protected String getNegatedFilterQuery() {
        return "subscription->'channel'->>'type' <> ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, this.channelType.toCode());
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return this.channelType.toCode();
    }

    @Override
    protected boolean resourceMatches(Subscription resource) {
        return this.valueAndType.negated ^ (resource.hasChannel() && resource.getChannel().hasType() && Objects.equals(resource.getChannel().getType(), this.channelType));
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "subscription->'channel'->>'type'" + sortDirectionWithSpacePrefix;
    }
}

