/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.parameters;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.parameters.basic.AbstractTokenParameter;
import dev.dsf.fhir.search.parameters.basic.TokenSearchType;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Enumerations;

@SearchQueryParameter.SearchParameterDefinition(name="contentType", definition="http://hl7.org/fhir/SearchParameter/Binary-contentType", type=Enumerations.SearchParamType.TOKEN, documentation="The MIME type of the actual binary content")
public class BinaryContentType
extends AbstractTokenParameter<Binary> {
    public static final String PARAMETER_NAME = "contentType";
    private CodeType contentType;

    public BinaryContentType() {
        super(Binary.class, PARAMETER_NAME);
    }

    @Override
    protected void doConfigure(List<? super SearchQueryParameterError> errors, String queryParameterName, String queryParameterValue) {
        super.doConfigure(errors, queryParameterName, queryParameterValue);
        if (this.valueAndType != null && this.valueAndType.type == TokenSearchType.CODE) {
            this.contentType = this.toContentType(this.valueAndType.codeValue);
        }
    }

    private CodeType toContentType(String contentType) {
        if (contentType == null || contentType.isBlank()) {
            return null;
        }
        return new CodeType(contentType);
    }

    @Override
    public boolean isDefined() {
        return super.isDefined() && this.contentType != null;
    }

    @Override
    protected String getPositiveFilterQuery() {
        return "binary_json->>'contentType' = ?";
    }

    @Override
    protected String getNegatedFilterQuery() {
        return "binary_json->>'contentType' <> ?";
    }

    @Override
    public int getSqlParameterCount() {
        return 1;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        statement.setString(parameterIndex, (String)this.contentType.getValue());
    }

    @Override
    public String getBundleUriQueryParameterValue() {
        return (String)this.contentType.getValue();
    }

    @Override
    protected boolean resourceMatches(Binary resource) {
        return this.valueAndType.negated ^ resource.hasContentType() && resource.getContentType().equals(this.contentType.getValue());
    }

    @Override
    protected String getSortSql(String sortDirectionWithSpacePrefix) {
        return "binary_json->>'contentType'" + sortDirectionWithSpacePrefix;
    }
}

