/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search.filter;

import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.search.filter.AbstractIdentityFilter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.postgresql.util.PGobject;

abstract class AbstractMetaTagAuthorizationRoleIdentityFilter
extends AbstractIdentityFilter {
    AbstractMetaTagAuthorizationRoleIdentityFilter(Identity identity, String resourceTable, String resourceIdColumn) {
        super(identity, resourceTable, resourceIdColumn);
    }

    @Override
    public String getFilterQuery() {
        if (this.identity.isLocalIdentity() && this.identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            return "(SELECT count(*) FROM read_access WHERE read_access.resource_id = " + this.resourceTable + "." + this.resourceIdColumn + " AND read_access.resource_version = " + this.resourceTable + ".version AND (read_access.organization_id = ? OR read_access.access_type = 'ALL' OR read_access.access_type = 'LOCAL')) > 0";
        }
        if (this.identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            return "(SELECT count(*) FROM read_access WHERE read_access.resource_id = " + this.resourceTable + "." + this.resourceIdColumn + " AND read_access.resource_version = " + this.resourceTable + ".version AND (read_access.organization_id = ? OR read_access.access_type = 'ALL')) > 0";
        }
        return "FALSE";
    }

    @Override
    public int getSqlParameterCount() {
        return this.identity.hasDsfRole((DsfRole)FhirServerRole.READ) ? 1 : 0;
    }

    @Override
    public void modifyStatement(int parameterIndex, int subqueryParameterIndex, PreparedStatement statement) throws SQLException {
        if (this.identity.hasDsfRole((DsfRole)FhirServerRole.READ)) {
            String usersOrganizationId = this.identity.getOrganization().getIdElement().getIdPart();
            statement.setObject(parameterIndex, this.toUuidObject(usersOrganizationId));
        }
    }

    private PGobject toUuidObject(String uuid) throws SQLException {
        if (uuid == null) {
            return null;
        }
        PGobject uuidObject = new PGobject();
        uuidObject.setType("UUID");
        uuidObject.setValue(uuid);
        return uuidObject;
    }
}

