/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.function.BiFunctionWithSqlException;
import dev.dsf.fhir.search.DbSearchQuery;
import dev.dsf.fhir.search.Matcher;
import dev.dsf.fhir.search.PageAndCount;
import dev.dsf.fhir.search.SearchQueryIdentityFilter;
import dev.dsf.fhir.search.SearchQueryIncludeParameterConfiguration;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterError;
import dev.dsf.fhir.search.SearchQueryParameterFactory;
import dev.dsf.fhir.search.SearchQueryRevIncludeParameter;
import dev.dsf.fhir.search.SearchQueryRevIncludeParameterFactory;
import dev.dsf.fhir.search.SearchQuerySortParameterConfiguration;
import jakarta.ws.rs.core.UriBuilder;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQuery<R extends Resource>
implements DbSearchQuery,
Matcher {
    public static final String PARAMETER_INCLUDE = "_include";
    public static final String PARAMETER_REVINCLUDE = "_revinclude";
    public static final String PARAMETER_SORT = "_sort";
    public static final String PARAMETER_PAGE = "_page";
    public static final String PARAMETER_COUNT = "_count";
    public static final String PARAMETER_FORMAT = "_format";
    public static final String PARAMETER_PRETTY = "_pretty";
    public static final String PARAMETER_SUMMARY = "_summary";
    public static final String[] STANDARD_PARAMETERS = new String[]{"_sort", "_include", "_revinclude", "_page", "_count", "_format", "_pretty", "_summary"};
    private static final String[] SINGLE_VALUE_PARAMETERS = new String[]{"_sort", "_page", "_count", "_format", "_pretty", "_summary"};
    private static final Logger logger = LoggerFactory.getLogger(SearchQuery.class);
    private final Class<R> resourceType;
    private final String resourceColumn;
    private final String resourceTable;
    private final SearchQueryIdentityFilter identityFilter;
    private final PageAndCount pageAndCount;
    private final Map<String, SearchQueryParameterFactory<R>> searchParameterFactoriesByParameterName = new HashMap<String, SearchQueryParameterFactory<R>>();
    private final Map<String, SearchQueryParameterFactory<R>> searchParameterFactoriesBySortParameterName = new HashMap<String, SearchQueryParameterFactory<R>>();
    private final Map<String, SearchQueryParameterFactory<R>> includeParameterFactoriesByValue = new HashMap<String, SearchQueryParameterFactory<R>>();
    private final Map<String, SearchQueryRevIncludeParameterFactory> revIncludeParameterFactoriesByValue = new HashMap<String, SearchQueryRevIncludeParameterFactory>();
    private final List<SearchQueryParameter<R>> searchParameters = new ArrayList<SearchQueryParameter<R>>();
    private final List<SearchQuerySortParameterConfiguration> sortParameters = new ArrayList<SearchQuerySortParameterConfiguration>();
    private final List<SearchQueryIncludeParameterConfiguration> includeParameters = new ArrayList<SearchQueryIncludeParameterConfiguration>();
    private final List<SearchQueryIncludeParameterConfiguration> revIncludeParameters = new ArrayList<SearchQueryIncludeParameterConfiguration>();
    private final List<SearchQueryParameterError> errors = new ArrayList<SearchQueryParameterError>();
    private String filterQuery;
    private String sortSql;
    private String includeSql;
    private String revIncludeSql;

    SearchQuery(Class<R> resourceType, String resourceTable, String resourceColumn, SearchQueryIdentityFilter identityFilter, PageAndCount pageAndCount, List<SearchQueryParameterFactory<R>> searchParameterFactories, List<SearchQueryRevIncludeParameterFactory> searchRevIncludeParameterFactories) {
        this.resourceType = resourceType;
        this.resourceTable = resourceTable;
        this.resourceColumn = resourceColumn;
        this.identityFilter = identityFilter;
        this.pageAndCount = pageAndCount;
        if (searchParameterFactories != null) {
            searchParameterFactories.forEach(f -> {
                f.getNameAndModifiedNames().forEach(name -> {
                    SearchQueryParameterFactory existingMapping = this.searchParameterFactoriesByParameterName.putIfAbsent((String)name, (SearchQueryParameterFactory<R>)f);
                    if (existingMapping != null) {
                        throw new RuntimeException("More than one " + SearchQueryParameter.class.getName() + " configured for parameter name " + name);
                    }
                });
                f.getSortNames().forEach(name -> {
                    SearchQueryParameterFactory existingMapping = this.searchParameterFactoriesBySortParameterName.putIfAbsent((String)name, (SearchQueryParameterFactory<R>)f);
                    if (existingMapping != null) {
                        throw new RuntimeException("More than one " + SearchQueryParameter.class.getName() + " configured for sort parameter name " + name);
                    }
                });
                if (f.isIncludeParameter()) {
                    f.getIncludeParameterValues().forEach(value -> {
                        SearchQueryParameterFactory existingMapping = this.includeParameterFactoriesByValue.putIfAbsent((String)value, (SearchQueryParameterFactory<R>)f);
                        if (existingMapping != null) {
                            throw new RuntimeException("More than one " + SearchQueryParameter.class.getName() + " configured for include parameter value " + value);
                        }
                    });
                }
            });
        }
        if (searchRevIncludeParameterFactories != null) {
            searchRevIncludeParameterFactories.forEach(f -> f.getRevIncludeParameterValues().forEach(value -> {
                SearchQueryRevIncludeParameterFactory existingMapping = this.revIncludeParameterFactoriesByValue.putIfAbsent((String)value, (SearchQueryRevIncludeParameterFactory)f);
                if (existingMapping != null) {
                    throw new RuntimeException("More than one " + SearchQueryRevIncludeParameter.class.getName() + " configured for revinclude parameter value " + value);
                }
            }));
        }
    }

    public SearchQuery<R> configureParameters(Map<String, List<String>> queryParameters) {
        this.checkSingleValueParameters(queryParameters);
        this.filterQuery = this.createFilterQuery(queryParameters);
        this.includeSql = this.createIncludeSql(queryParameters.getOrDefault(PARAMETER_INCLUDE, Collections.emptyList()));
        this.revIncludeSql = this.createRevIncludeSql(queryParameters.getOrDefault(PARAMETER_REVINCLUDE, Collections.emptyList()));
        this.sortSql = this.createSortSql(queryParameters.getOrDefault(PARAMETER_SORT, Collections.emptyList()));
        return this;
    }

    private void checkSingleValueParameters(Map<String, List<String>> queryParameters) {
        Arrays.stream(SINGLE_VALUE_PARAMETERS).forEach(parameter -> {
            List values = (List)queryParameters.get(parameter);
            if (values != null && values.size() > 1) {
                this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, (String)parameter, null, "More than one query parameter `" + parameter + "`"));
            }
        });
    }

    private String createFilterQuery(Map<String, List<String>> queryParameters) {
        queryParameters.entrySet().stream().filter(e -> Arrays.stream(STANDARD_PARAMETERS).noneMatch(p -> p.equals(e.getKey()))).forEach(e -> {
            SearchQueryParameterFactory<R> queryParameterFactory = this.searchParameterFactoriesByParameterName.get(e.getKey());
            if (queryParameterFactory != null) {
                ((List)e.getValue()).stream().filter(v -> v != null && !v.isBlank()).forEach(value -> this.searchParameters.add(queryParameterFactory.createQueryParameter().configure(this.errors, (String)e.getKey(), (String)value)));
            } else {
                this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_PARAMETER, (String)e.getKey(), null, "Query parameter `" + (String)e.getKey() + "` not supported"));
            }
        });
        Stream<String> elements = this.searchParameters.stream().filter(SearchQueryParameter::isDefined).map(SearchQueryParameter::getFilterQuery);
        if (this.identityFilter != null && !this.identityFilter.getFilterQuery().isEmpty()) {
            elements = Stream.concat(Stream.of(this.identityFilter.getFilterQuery()), elements);
        }
        return elements.collect(Collectors.joining(" AND "));
    }

    public List<SearchQueryParameterError> getUnsupportedQueryParameters() {
        return this.errors;
    }

    private String createSortSql(List<String> sortParameterValues) {
        if (sortParameterValues.size() <= 0) {
            return "";
        }
        String sortParameterValue = sortParameterValues.get(0);
        if (sortParameterValue == null || sortParameterValue.isBlank()) {
            return "";
        }
        HashSet<String> supportedSortValues = new HashSet<String>();
        for (String value : sortParameterValue.split(",")) {
            if (value == null || value.isBlank()) continue;
            SearchQueryParameterFactory<R> sortParameterFactory = this.searchParameterFactoriesBySortParameterName.get(value);
            if (sortParameterFactory != null) {
                if (!supportedSortValues.contains(sortParameterFactory.getName())) {
                    supportedSortValues.add(sortParameterFactory.getName());
                    this.sortParameters.add(sortParameterFactory.createQuerySortParameter().configureSort(this.errors, value));
                    continue;
                }
                this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, PARAMETER_SORT, null, "More than one _sort query parameter valus `" + value + "`"));
                continue;
            }
            this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, PARAMETER_SORT, null, "_sort query parameter value `" + value + "` not supported"));
        }
        return this.sortParameters.isEmpty() ? "" : this.sortParameters.stream().map(SearchQuerySortParameterConfiguration::getSql).collect(Collectors.joining(", ", " ORDER BY ", ""));
    }

    private String createIncludeSql(List<String> includeParameterValues) {
        HashSet<String> supportedIncludeValues = new HashSet<String>();
        for (String value : includeParameterValues) {
            if (value == null || value.isBlank()) continue;
            SearchQueryParameterFactory<R> includeParameterFactory = this.includeParameterFactoriesByValue.get(value);
            if (includeParameterFactory != null) {
                if (!supportedIncludeValues.contains(value)) {
                    supportedIncludeValues.add(value);
                    this.includeParameters.add(includeParameterFactory.createQueryIncludeParameter().configureInclude(this.errors, value));
                    continue;
                }
                this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, PARAMETER_INCLUDE, null, "More than one _include query parameter value " + value));
                continue;
            }
            this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, PARAMETER_INCLUDE, null, "_include query parameter value " + value + " not supported"));
        }
        return this.includeParameters.isEmpty() ? "" : this.includeParameters.stream().map(SearchQueryIncludeParameterConfiguration::getSql).collect(Collectors.joining(", ", ", ", ""));
    }

    private String createRevIncludeSql(List<String> revIncludeParameterValues) {
        HashSet<String> supportedRevIncludeValues = new HashSet<String>();
        for (String value : revIncludeParameterValues) {
            if (value == null || value.isBlank()) continue;
            SearchQueryRevIncludeParameterFactory revIncludeParameterFactory = this.revIncludeParameterFactoriesByValue.get(value);
            if (revIncludeParameterFactory != null) {
                if (!supportedRevIncludeValues.contains(value)) {
                    supportedRevIncludeValues.add(value);
                    this.revIncludeParameters.add(revIncludeParameterFactory.createQueryRevIncludeParameter().configureRevInclude(this.errors, value));
                    continue;
                }
                this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNSUPPORTED_NUMBER_OF_VALUES, PARAMETER_REVINCLUDE, null, "More than one _revinclude query parameter value " + value));
                continue;
            }
            this.errors.add(new SearchQueryParameterError(SearchQueryParameterError.SearchQueryParameterErrorType.UNPARSABLE_VALUE, PARAMETER_REVINCLUDE, null, "_revinclude query parameter value " + value + " not supported"));
        }
        return this.revIncludeParameters.isEmpty() ? "" : this.revIncludeParameters.stream().map(SearchQueryIncludeParameterConfiguration::getSql).collect(Collectors.joining(", ", ", ", ""));
    }

    @Override
    public String getCountSql() {
        String countQueryMain = "SELECT count(*) FROM current_" + this.resourceTable;
        return countQueryMain + (String)(!this.filterQuery.isEmpty() ? " WHERE " + this.filterQuery : "");
    }

    @Override
    public String getSearchSql() {
        String searchQueryMain = "SELECT " + this.resourceColumn + this.includeSql + this.revIncludeSql + " FROM current_" + this.resourceTable;
        return searchQueryMain + (String)(!this.filterQuery.isEmpty() ? " WHERE " + this.filterQuery : "") + this.sortSql + this.pageAndCount.getSql();
    }

    @Override
    public void modifyStatement(PreparedStatement statement, BiFunctionWithSqlException<String, Object[], Array> arrayCreator) throws SQLException {
        try {
            List filtered = this.searchParameters.stream().filter(SearchQueryParameter::isDefined).collect(Collectors.toList());
            int index = 0;
            if (this.identityFilter != null) {
                while (index < this.identityFilter.getSqlParameterCount()) {
                    int i = ++index;
                    this.identityFilter.modifyStatement(i, i, statement);
                }
            }
            for (SearchQueryParameter q : filtered) {
                for (int i = 0; i < q.getSqlParameterCount(); ++i) {
                    q.modifyStatement(++index, i + 1, statement, arrayCreator);
                }
            }
        }
        catch (SQLException e) {
            logger.debug("Error while modifying prepared statement '{}'", (Object)statement.toString(), (Object)e);
            throw e;
        }
    }

    @Override
    public PageAndCount getPageAndCount() {
        return this.pageAndCount;
    }

    public UriBuilder configureBundleUri(UriBuilder bundleUri) {
        Object[] values;
        Objects.requireNonNull(bundleUri, "bundleUri");
        this.searchParameters.stream().filter(SearchQueryParameter::isDefined).collect(Collectors.toMap(SearchQueryParameter::getBundleUriQueryParameterName, p -> Collections.singletonList(p.getBundleUriQueryParameterValue()), (v1, v2) -> {
            ArrayList list = new ArrayList(v1);
            list.addAll(v2);
            return list;
        })).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> bundleUri.replaceQueryParam((String)e.getKey(), ((List)e.getValue()).toArray()));
        if (!this.sortParameters.isEmpty()) {
            values = this.sortParameters.stream().map(SearchQuerySortParameterConfiguration::getBundleUriQueryParameterValuePart).collect(Collectors.joining(","));
            bundleUri.replaceQueryParam(PARAMETER_SORT, new Object[]{values});
        }
        if (!this.includeParameters.isEmpty()) {
            values = this.includeParameters.stream().map(SearchQueryIncludeParameterConfiguration::getBundleUriQueryParameterValues).toArray();
            bundleUri.replaceQueryParam(PARAMETER_INCLUDE, values);
        }
        if (!this.revIncludeParameters.isEmpty()) {
            values = this.revIncludeParameters.stream().map(SearchQueryIncludeParameterConfiguration::getBundleUriQueryParameterValues).toArray();
            bundleUri.replaceQueryParam(PARAMETER_REVINCLUDE, values);
        }
        return bundleUri;
    }

    public Class<R> getResourceType() {
        return this.resourceType;
    }

    @Override
    public void resloveReferencesForMatching(Resource resource, DaoProvider daoProvider) throws SQLException {
        if (resource == null || !this.getResourceType().isInstance(resource)) {
            return;
        }
        List<SQLException> exceptions = this.searchParameters.stream().filter(SearchQueryParameter::isDefined).map(p -> {
            try {
                p.resolveReferencesForMatching(resource, daoProvider);
                return null;
            }
            catch (SQLException e) {
                return e;
            }
        }).filter(e -> e != null).collect(Collectors.toList());
        if (!exceptions.isEmpty()) {
            SQLException sqlException = new SQLException("Error while resoling references");
            exceptions.forEach(sqlException::addSuppressed);
            throw sqlException;
        }
    }

    @Override
    public boolean matches(Resource resource) {
        if (resource == null || !this.getResourceType().isInstance(resource)) {
            return false;
        }
        return this.searchParameters.stream().filter(SearchQueryParameter::isDefined).map(p -> p.matches(resource)).allMatch(b -> b);
    }

    @Override
    public void modifyIncludeResource(Resource resource, int columnIndex, Connection connection) throws SQLException {
        int includeParameterCount = this.includeParameters.size();
        int revIncludeParameterCount = this.revIncludeParameters.size();
        if (includeParameterCount > 0 && columnIndex - 1 <= includeParameterCount) {
            this.includeParameters.get(columnIndex - 2).modifyIncludeResource(resource, connection);
        } else if (this.revIncludeParameters.size() > 0 && columnIndex - 1 - includeParameterCount <= revIncludeParameterCount) {
            this.revIncludeParameters.get(columnIndex - 2 - includeParameterCount).modifyIncludeResource(resource, connection);
        } else {
            logger.warn("Unexpected column-index {}, column-index - 1 larger than include ({}) + revinclude ({}) parameter count {}", new Object[]{columnIndex, includeParameterCount, revIncludeParameterCount, includeParameterCount + revIncludeParameterCount});
            throw new IllegalStateException("Unexpected column-index " + columnIndex + ", column-index - 1 larger than include (" + includeParameterCount + ") + revinclude (" + revIncludeParameterCount + ") parameter count " + (includeParameterCount + revIncludeParameterCount));
        }
    }

    public static class SearchQueryBuilder<R extends Resource> {
        private final Class<R> resourceType;
        private final String resourceTable;
        private final String resourceColumn;
        private final PageAndCount pageAndCount;
        private final List<SearchQueryParameterFactory<R>> searchParameters = new ArrayList<SearchQueryParameterFactory<R>>();
        private final List<SearchQueryRevIncludeParameterFactory> revIncludeParameters = new ArrayList<SearchQueryRevIncludeParameterFactory>();
        private SearchQueryIdentityFilter identityFilter;

        public static <R extends Resource> SearchQueryBuilder<R> create(Class<R> resourceType, String resourceTable, String resourceColumn, PageAndCount pageAndCount) {
            return new SearchQueryBuilder<R>(resourceType, resourceTable, resourceColumn, pageAndCount);
        }

        private SearchQueryBuilder(Class<R> resourceType, String resourceTable, String resourceColumn, PageAndCount pageAndCount) {
            this.resourceType = resourceType;
            this.resourceTable = resourceTable;
            this.resourceColumn = resourceColumn;
            this.pageAndCount = pageAndCount;
        }

        public SearchQueryBuilder<R> with(SearchQueryIdentityFilter identityFilter) {
            this.identityFilter = identityFilter;
            return this;
        }

        public SearchQueryBuilder<R> with(SearchQueryParameterFactory<R> searchParameters) {
            this.searchParameters.add(searchParameters);
            return this;
        }

        public SearchQueryBuilder<R> with(SearchQueryParameterFactory<R> ... searchParameters) {
            return this.with(Arrays.asList(searchParameters));
        }

        public SearchQueryBuilder<R> with(List<? extends SearchQueryParameterFactory<R>> searchParameters) {
            this.searchParameters.addAll(searchParameters);
            return this;
        }

        public SearchQueryBuilder<R> withRevInclude(SearchQueryRevIncludeParameterFactory revIncludeParameter) {
            this.revIncludeParameters.add(revIncludeParameter);
            return this;
        }

        public SearchQueryBuilder<R> withRevInclude(SearchQueryRevIncludeParameterFactory ... revIncludeParameters) {
            return this.withRevInclude(Arrays.asList(revIncludeParameters));
        }

        public SearchQueryBuilder<R> withRevInclude(List<SearchQueryRevIncludeParameterFactory> revIncludeParameters) {
            this.revIncludeParameters.addAll(revIncludeParameters);
            return this;
        }

        public SearchQuery<R> build() {
            return new SearchQuery<R>(this.resourceType, this.resourceTable, this.resourceColumn, this.identityFilter, this.pageAndCount, this.searchParameters, this.revIncludeParameters);
        }
    }
}

