/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PageAndCount {
    private static final PageAndCount EXISTS = new PageAndCount(0, 0, 0);
    private static final PageAndCount SINGLE = new PageAndCount(1, 1, 1);
    private final int page;
    private final int count;

    public static PageAndCount single() {
        return SINGLE;
    }

    public static PageAndCount exists() {
        return EXISTS;
    }

    public static PageAndCount from(Map<String, List<String>> queryParameters, int defaultPageCount) {
        Integer page = PageAndCount.getFirstInt(queryParameters, "_page");
        Integer count = PageAndCount.getFirstInt(queryParameters, "_count");
        return new PageAndCount(page, count, defaultPageCount);
    }

    private static Integer getFirstInt(Map<String, List<String>> queryParameters, String key) {
        List values = queryParameters.getOrDefault(key, Collections.emptyList());
        if (values.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf((String)values.get(0));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static PageAndCount from(int page, int count) {
        Math.multiplyExact(page, count);
        return new PageAndCount(page, count, count);
    }

    private PageAndCount(Integer page, Integer count, int defaultPageCount) {
        int effectivePage;
        int n = page == null ? 1 : (effectivePage = page < 0 ? 0 : page);
        int effectiveCount = count == null ? defaultPageCount : (count < 0 ? 0 : count);
        long testOverflow = (long)effectivePage * (long)effectiveCount;
        if (testOverflow > Integer.MAX_VALUE) {
            effectivePage = 1;
            effectiveCount = defaultPageCount;
        }
        this.page = effectivePage;
        this.count = effectiveCount;
    }

    public String getSql() {
        return " LIMIT " + this.count + (String)(this.page > 1 ? " OFFSET " + this.getOffset() : "");
    }

    private int getOffset() {
        return (this.page - 1) * this.count;
    }

    public boolean isCountOnly(int total) {
        return this.page < 1 || this.count < 1 || this.page > this.getLastPage(total);
    }

    public int getPage() {
        return this.page;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isLastPage(int total) {
        return this.page >= this.getLastPage(total);
    }

    public int getLastPage(int total) {
        return this.count < 1 ? 0 : (int)Math.ceil((double)total / (double)this.count);
    }
}

