/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.help;

import dev.dsf.fhir.dao.command.CommandList;
import dev.dsf.fhir.dao.exception.BadBundleException;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.exception.ResourceNotFoundException;
import dev.dsf.fhir.dao.exception.ResourceNotMarkedDeletedException;
import dev.dsf.fhir.dao.exception.ResourceVersionNoMatchException;
import dev.dsf.fhir.function.RunnableWithSqlAndResourceNotFoundException;
import dev.dsf.fhir.function.RunnableWithSqlException;
import dev.dsf.fhir.function.RunnableWithSqlResourceNotFoundAndResourceNotMarkedDeletedException;
import dev.dsf.fhir.function.SupplierWithSqlAndResourceDeletedException;
import dev.dsf.fhir.function.SupplierWithSqlAndResourceNotFoundAndResouceVersionNoMatchException;
import dev.dsf.fhir.function.SupplierWithSqlAndResourceNotFoundException;
import dev.dsf.fhir.function.SupplierWithSqlException;
import dev.dsf.fhir.help.ResponseGenerator;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Date;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandler.class);
    private final ResponseGenerator responseGenerator;

    public ExceptionHandler(ResponseGenerator responseGenerator) {
        this.responseGenerator = responseGenerator;
    }

    public void handleSqlException(RunnableWithSqlException s) {
        try {
            s.run();
        }
        catch (SQLException e) {
            throw this.internalServerError(e);
        }
    }

    public <T> T handleSqlException(SupplierWithSqlException<T> s) {
        try {
            return s.get();
        }
        catch (SQLException e) {
            throw this.internalServerError(e);
        }
    }

    public WebApplicationException internalServerError(SQLException e) {
        logger.debug("Error while accessing DB", (Throwable)e);
        logger.error("Error while accessing DB: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.EXCEPTION, "Error while accessing DB");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)outcome).build());
    }

    public WebApplicationException internalServerError(ResourceDeletedException e) {
        logger.debug("Error while accessing DB, resource deleted", (Throwable)e);
        logger.error("Error while accessing DB, resource deleted: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.EXCEPTION, "Error while accessing DB");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)outcome).build());
    }

    public WebApplicationException internalServerError(ResourceNotFoundException e) {
        logger.debug("Error while accessing DB, resource not found", (Throwable)e);
        logger.error("Error while accessing DB, resource not found: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.EXCEPTION, "Error while accessing DB");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)outcome).build());
    }

    public WebApplicationException internalServerErrorBundleTransaction(Exception e) {
        logger.debug("Error while executing transaction bundle", (Throwable)e);
        logger.error("Error while executing transaction bundle: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.EXCEPTION, "Error while executing transaction bundle");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)outcome).build());
    }

    public WebApplicationException internalServerErrorBundleBatch(Exception e) {
        logger.debug("Error while executing batch bundle element", (Throwable)e);
        logger.error("Error while executing batch bundle element: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.EXCEPTION, "Error while executing batch bundle element");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)outcome).build());
    }

    public <T> T handleSqlExAndResourceNotFoundExAndResouceVersionNonMatchEx(String resourceTypeName, SupplierWithSqlAndResourceNotFoundAndResouceVersionNoMatchException<T> s) {
        try {
            return s.get();
        }
        catch (ResourceNotFoundException e) {
            throw new WebApplicationException(this.responseGenerator.notFound(e.getId(), resourceTypeName));
        }
        catch (ResourceVersionNoMatchException e) {
            throw this.resourceVersionNoMatch(resourceTypeName, e);
        }
        catch (SQLException e) {
            throw this.internalServerError(e);
        }
    }

    private WebApplicationException resourceVersionNoMatch(String resourceTypeName, ResourceVersionNoMatchException e) {
        logger.error("{} with id {} expected version {} does not match latest version {}", new Object[]{resourceTypeName, e.getId(), e.getExpectedVersion(), e.getLatestVersion()});
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, "Resource with id " + e.getId() + " expected version " + e.getExpectedVersion() + " does not match latest version " + e.getLatestVersion());
        return new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)outcome).build());
    }

    public WebApplicationException notFound(String resourceTypeName) {
        logger.error("{} with id (not a UUID) not found", (Object)resourceTypeName);
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, resourceTypeName + " with id (not a UUID) not found");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)outcome).build());
    }

    public WebApplicationException notFound(String resourceTypeName, ResourceNotFoundException e) {
        logger.error("{} with id {} not found", (Object)resourceTypeName, (Object)e.getId());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, resourceTypeName + " with id " + e.getId() + " not found");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)outcome).build());
    }

    public <T> T handleSqlAndResourceDeletedException(String serverBase, String resourceTypeName, SupplierWithSqlAndResourceDeletedException<T> s) {
        try {
            return s.get();
        }
        catch (ResourceDeletedException e) {
            throw this.gone(serverBase, resourceTypeName, e);
        }
        catch (SQLException e) {
            throw this.internalServerError(e);
        }
    }

    public <T> T handleSqlAndResourceNotFoundException(String resourceTypeName, SupplierWithSqlAndResourceNotFoundException<T> s) {
        try {
            return s.get();
        }
        catch (ResourceNotFoundException e) {
            throw this.notFound(resourceTypeName, e);
        }
        catch (SQLException e) {
            throw this.internalServerError(e);
        }
    }

    public void handleSqlResourceNotFoundAndResourceNotMarkedDeletedException(String resourceTypeName, RunnableWithSqlResourceNotFoundAndResourceNotMarkedDeletedException r) {
        try {
            r.run();
        }
        catch (SQLException e) {
            throw this.internalServerError(e);
        }
        catch (ResourceNotFoundException e) {
            throw this.notFound(resourceTypeName, e);
        }
        catch (ResourceNotMarkedDeletedException e) {
            throw this.notMarkedDeleted(resourceTypeName, e);
        }
    }

    public WebApplicationException notMarkedDeleted(String resourceTypeName, ResourceNotMarkedDeletedException e) {
        logger.warn("{} with id {} is not marked as deleted", (Object)resourceTypeName, (Object)e.getId());
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.PROCESSING, resourceTypeName + " with id " + e.getId() + " is not marked deleted");
        return new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)outcome).build());
    }

    public WebApplicationException gone(String serverBase, String resourceTypeName, ResourceDeletedException e) {
        logger.warn("{} with given id is marked as deleted", (Object)resourceTypeName);
        OperationOutcome outcome = this.responseGenerator.createOutcome(OperationOutcome.IssueSeverity.ERROR, OperationOutcome.IssueType.DELETED, "Resource with id " + e.getId() + " is marked as deleted.");
        EntityTag tag = new EntityTag(e.getId().getVersionIdPart(), true);
        URI location = this.toUri(serverBase, resourceTypeName, e.getId());
        Date lastModified = Date.from(e.getDeleted().atZone(ZoneId.systemDefault()).toInstant());
        return new WebApplicationException(Response.status((Response.Status)Response.Status.GONE).tag(tag).cacheControl(ResponseGenerator.PRIVATE_NO_CACHE_NO_TRANSFORM).location(location).lastModified(lastModified).entity((Object)outcome).build());
    }

    private URI toUri(String serverBase, String resourceTypeName, IdType id) {
        try {
            return new URI(id.withServerBase(serverBase, resourceTypeName).getValue());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T catchAndLogSqlExceptionAndIfReturn(SupplierWithSqlException<T> s, Supplier<T> onSqlException) {
        try {
            return s.get();
        }
        catch (SQLException e) {
            logger.debug("Error while accessing DB", (Throwable)e);
            logger.warn("Error while accessing DB: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return onSqlException.get();
        }
    }

    public <T> T catchAndLogSqlAndResourceDeletedExceptionAndIfReturn(SupplierWithSqlAndResourceDeletedException<T> s, Supplier<T> onSqlException, Supplier<T> onResourceDeletedException) {
        try {
            return s.get();
        }
        catch (SQLException e) {
            logger.debug("Error while accessing DB", (Throwable)e);
            logger.warn("Error while accessing DB: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return onSqlException.get();
        }
        catch (ResourceDeletedException e) {
            logger.debug("Resource with id {} marked as deleted", (Object)e.getId(), (Object)e);
            logger.warn("Resource with id {} marked as deleted", (Object)e.getId());
            return onResourceDeletedException.get();
        }
    }

    public void catchAndLogSqlException(RunnableWithSqlException s) {
        try {
            s.run();
        }
        catch (SQLException e) {
            logger.debug("Error while accessing DB", (Throwable)e);
            logger.warn("Error while accessing DB: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    public void catchAndLogSqlAndResourceNotFoundException(String resourceTypeName, RunnableWithSqlAndResourceNotFoundException r) {
        try {
            r.run();
        }
        catch (ResourceNotFoundException e) {
            logger.debug("{} with id {} not found", new Object[]{resourceTypeName, e.getId(), e});
            logger.warn("{} with id {} not found", (Object)resourceTypeName, (Object)e.getId());
        }
        catch (SQLException e) {
            logger.debug("Error while accessing DB", (Throwable)e);
            logger.warn("Error while accessing DB: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    public <R> R catchAndLogSqlAndResourceNotFoundException(String resourceTypeName, SupplierWithSqlAndResourceNotFoundException<R> s, Supplier<R> onResourceNotFoundException, Supplier<R> onSqlException) {
        try {
            return s.get();
        }
        catch (ResourceNotFoundException e) {
            logger.debug("{} with id {} not found", new Object[]{resourceTypeName, e.getId(), e});
            logger.warn("{} with id {} not found", (Object)resourceTypeName, (Object)e.getId());
            return onResourceNotFoundException.get();
        }
        catch (SQLException e) {
            logger.debug("Error while accessing DB", (Throwable)e);
            logger.warn("Error while accessing DB: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return onSqlException.get();
        }
    }

    public CommandList handleBadBundleException(Supplier<CommandList> commandListCreator) {
        try {
            return commandListCreator.get();
        }
        catch (BadBundleException e) {
            logger.debug("Error while creating command list for bundle", (Throwable)e);
            logger.warn("Error while creating command list for bundle: {}", (Object)e.getMessage());
            throw new WebApplicationException(this.responseGenerator.badBundleRequest(e.getMessage()));
        }
    }
}

