/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import dev.dsf.fhir.function.BiFunctionWithSqlException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.DomainResource;

class ReadByUrlDaoJdbc<R extends DomainResource> {
    private final Supplier<DataSource> dataSourceSupplier;
    private final BiFunctionWithSqlException<ResultSet, Integer, R> resourceExtractor;
    private final String resourceTable;
    private final String resourceColumn;

    ReadByUrlDaoJdbc(Supplier<DataSource> dataSourceSupplier, BiFunctionWithSqlException<ResultSet, Integer, R> resourceExtractor, String resourceTable, String resourceColumn) {
        this.dataSourceSupplier = dataSourceSupplier;
        this.resourceExtractor = resourceExtractor;
        this.resourceTable = resourceTable;
        this.resourceColumn = resourceColumn;
    }

    Optional<R> readByUrlAndVersion(String urlAndVersion) throws SQLException {
        try (Connection connection = this.dataSourceSupplier.get().getConnection();){
            Optional<R> optional = this.readByUrlAndVersionWithTransaction(connection, urlAndVersion);
            return optional;
        }
    }

    public Optional<R> readByUrlAndVersionWithTransaction(Connection connection, String urlAndVersion) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        if (urlAndVersion == null || urlAndVersion.isBlank()) {
            return Optional.empty();
        }
        String[] split = urlAndVersion.split("[|]");
        if (split.length < 1 || split.length > 2) {
            return Optional.empty();
        }
        return this.readByUrlAndVersionWithTransaction(connection, split[0], split.length == 2 ? split[1] : null);
    }

    Optional<R> readByUrlAndVersion(String url, String version) throws SQLException {
        try (Connection connection = this.dataSourceSupplier.get().getConnection();){
            Optional<R> optional = this.readByUrlAndVersionWithTransaction(connection, url, version);
            return optional;
        }
    }

    Optional<R> readByUrlAndVersionWithTransaction(Connection connection, String url, String version) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        if (url == null || url.isBlank()) {
            return Optional.empty();
        }
        String versionSql = version != null && !version.isBlank() ? "AND " + this.resourceColumn + "->>'version' = ? " : "";
        String sql = "SELECT " + this.resourceColumn + " FROM current_" + this.resourceTable + " WHERE " + this.resourceColumn + "->>'url' = ? " + versionSql;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            Optional optional;
            block18: {
                ResultSet result;
                block16: {
                    Optional<DomainResource> optional2;
                    block17: {
                        statement.setString(1, url);
                        if (version != null && !version.isBlank()) {
                            statement.setString(2, version);
                        }
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block16;
                            optional2 = Optional.of((DomainResource)this.resourceExtractor.apply(result, 1));
                            if (result == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (result == null) break block18;
                result.close();
            }
            return optional;
        }
    }
}

