/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.parser.DataFormatException;
import dev.dsf.fhir.dao.ReadAccessDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.sql.DataSource;
import org.postgresql.util.PGobject;
import org.springframework.beans.factory.InitializingBean;

public class ReadAccessDaoJdbc
implements ReadAccessDao,
InitializingBean {
    private final DataSource dataSource;

    public ReadAccessDaoJdbc(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.dataSource, "dataSource");
    }

    @Override
    public List<String> getAccessTypes(Connection connection, UUID resourceId, long version, boolean localIdentity, UUID organizationId) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(resourceId, "resourceId");
        if (version <= 0L) {
            throw new IllegalArgumentException("version <= 0");
        }
        Objects.requireNonNull(organizationId, "organizationId");
        try (PreparedStatement statement = connection.prepareStatement(this.getReadAllowedQuery(localIdentity));){
            ArrayList<String> arrayList;
            block14: {
                statement.setObject(1, this.uuidToPgObject(resourceId));
                statement.setLong(2, version);
                statement.setObject(3, this.uuidToPgObject(organizationId));
                ResultSet result = statement.executeQuery();
                try {
                    ArrayList<String> accessTypes = new ArrayList<String>();
                    while (result.next()) {
                        accessTypes.add(result.getString(1));
                    }
                    arrayList = accessTypes;
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
    }

    private String getReadAllowedQuery(boolean localIdentity) {
        if (localIdentity) {
            return "SELECT DISTINCT access_type FROM read_access WHERE resource_id = ? AND resource_version = ? AND (access_type = 'ALL' OR access_type = 'LOCAL' OR organization_id = ?) ORDER BY access_type";
        }
        return "SELECT DISTINCT access_type FROM read_access WHERE resource_id = ? AND resource_version = ? AND (access_type = 'ALL' OR organization_id = ?) ORDER BY access_type";
    }

    private PGobject uuidToPgObject(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            PGobject o = new PGobject();
            o.setType("UUID");
            o.setValue(uuid.toString());
            return o;
        }
        catch (DataFormatException | SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

