/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.jdbc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.ResourceDao;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.exception.ResourceNotFoundException;
import dev.dsf.fhir.dao.exception.ResourceNotMarkedDeletedException;
import dev.dsf.fhir.dao.exception.ResourceVersionNoMatchException;
import dev.dsf.fhir.dao.jdbc.PreparedStatementFactory;
import dev.dsf.fhir.dao.jdbc.PreparedStatementFactoryDefault;
import dev.dsf.fhir.search.DbSearchQuery;
import dev.dsf.fhir.search.PageAndCount;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import dev.dsf.fhir.search.SearchQueryIdentityFilter;
import dev.dsf.fhir.search.SearchQueryIncludeParameter;
import dev.dsf.fhir.search.SearchQueryParameter;
import dev.dsf.fhir.search.SearchQueryParameterFactory;
import dev.dsf.fhir.search.SearchQueryRevIncludeParameter;
import dev.dsf.fhir.search.SearchQueryRevIncludeParameterFactory;
import dev.dsf.fhir.search.parameters.ResourceId;
import dev.dsf.fhir.search.parameters.ResourceLastUpdated;
import dev.dsf.fhir.search.parameters.ResourceProfile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

abstract class AbstractResourceDaoJdbc<R extends Resource>
implements ResourceDao<R>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceDaoJdbc.class);
    private final DataSource dataSource;
    private final DataSource permanentDeleteDataSource;
    private final Class<R> resourceType;
    private final String resourceTypeName;
    private final String resourceTable;
    private final String resourceColumn;
    private final String resourceIdColumn;
    private final PreparedStatementFactory<R> preparedStatementFactory;
    private final Function<Identity, SearchQueryIdentityFilter> identityFilter;
    private final List<SearchQueryParameterFactory<R>> searchParameterFactories = new ArrayList<SearchQueryParameterFactory<R>>();
    private final List<SearchQueryRevIncludeParameterFactory> searchRevIncludeParameterFactories = new ArrayList<SearchQueryRevIncludeParameterFactory>();
    private final SearchQueryParameterFactory<R> resourceIdFactory;
    private final SearchQueryParameterFactory<R> resourceLastUpdatedFactory;
    private final SearchQueryParameterFactory<R> resourceProfileFactory;

    protected static <R extends Resource> SearchQueryParameterFactory<R> factory(String parameterName, Supplier<SearchQueryParameter<R>> supplier) {
        Objects.requireNonNull(parameterName, "parameterName");
        Objects.requireNonNull(supplier, "supplier");
        return new SearchQueryParameterFactory<R>(parameterName, supplier, null, null, null);
    }

    protected static SearchQueryRevIncludeParameterFactory factory(Supplier<SearchQueryRevIncludeParameter> revIncludeSupplier, List<String> revIncludeParameterValues) {
        Objects.requireNonNull(revIncludeSupplier, "revIncludeSupplier");
        Objects.requireNonNull(revIncludeParameterValues, "revIncludeParameterValues");
        return new SearchQueryRevIncludeParameterFactory(revIncludeSupplier, revIncludeParameterValues);
    }

    protected static <R extends Resource> SearchQueryParameterFactory<R> factory(String parameterName, Supplier<SearchQueryParameter<R>> supplier, List<String> nameModifiers, Supplier<SearchQueryIncludeParameter<R>> includeSupplier, List<String> includeParameterValues) {
        Objects.requireNonNull(parameterName, "parameterName");
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(nameModifiers, "nameModifiers");
        Objects.requireNonNull(includeSupplier, "includeSupplier");
        Objects.requireNonNull(includeParameterValues, "includeParameterValues");
        return new SearchQueryParameterFactory<R>(parameterName, supplier, nameModifiers, includeSupplier, includeParameterValues);
    }

    protected static <R extends Resource> SearchQueryParameterFactory<R> factory(String parameterName, Supplier<SearchQueryParameter<R>> supplier, List<String> nameModifiers) {
        Objects.requireNonNull(parameterName, "parameterName");
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(nameModifiers, "nameModifiers");
        return new SearchQueryParameterFactory<R>(parameterName, supplier, nameModifiers, null, null);
    }

    AbstractResourceDaoJdbc(DataSource dataSource, DataSource permanentDeleteDataSource, FhirContext fhirContext, Class<R> resourceType, String resourceTable, String resourceColumn, String resourceIdColumn, Function<Identity, SearchQueryIdentityFilter> userFilter, List<SearchQueryParameterFactory<R>> searchParameterFactories, List<SearchQueryRevIncludeParameterFactory> searchRevIncludeParameterFactories) {
        this(dataSource, permanentDeleteDataSource, resourceType, resourceTable, resourceColumn, resourceIdColumn, new PreparedStatementFactoryDefault<R>(fhirContext, resourceType, resourceTable, resourceIdColumn, resourceColumn), userFilter, searchParameterFactories, searchRevIncludeParameterFactories);
    }

    AbstractResourceDaoJdbc(DataSource dataSource, DataSource permanentDeleteDataSource, Class<R> resourceType, String resourceTable, String resourceColumn, String resourceIdColumn, PreparedStatementFactory<R> preparedStatementFactory, Function<Identity, SearchQueryIdentityFilter> userFilter, List<SearchQueryParameterFactory<R>> searchParameterFactories, List<SearchQueryRevIncludeParameterFactory> searchRevIncludeParameterFactories) {
        this.dataSource = dataSource;
        this.permanentDeleteDataSource = permanentDeleteDataSource;
        this.resourceType = resourceType;
        this.resourceTypeName = Objects.requireNonNull(resourceType, "resourceType").getAnnotation(ResourceDef.class).name();
        this.resourceTable = resourceTable;
        this.resourceColumn = resourceColumn;
        this.resourceIdColumn = resourceIdColumn;
        this.preparedStatementFactory = preparedStatementFactory;
        this.identityFilter = userFilter;
        if (searchParameterFactories != null) {
            this.searchParameterFactories.addAll(searchParameterFactories);
        }
        if (searchRevIncludeParameterFactories != null) {
            this.searchRevIncludeParameterFactories.addAll(searchRevIncludeParameterFactories);
        }
        this.resourceIdFactory = new SearchQueryParameterFactory("_id", () -> new ResourceId(resourceType, resourceIdColumn));
        this.resourceLastUpdatedFactory = new SearchQueryParameterFactory("_lastUpdated", () -> new ResourceLastUpdated(resourceType, resourceColumn));
        this.resourceProfileFactory = new SearchQueryParameterFactory("_profile", () -> new ResourceProfile(resourceType, resourceColumn), ResourceProfile.getNameModifiers());
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.dataSource, "dataSource");
        Objects.requireNonNull(this.permanentDeleteDataSource, "permanentDeleteDataSource");
        Objects.requireNonNull(this.resourceType, "resourceType");
        Objects.requireNonNull(this.resourceTable, "resourceTable");
        Objects.requireNonNull(this.resourceColumn, "resourceColumn");
        Objects.requireNonNull(this.resourceIdColumn, "resourceIdColumn");
        Objects.requireNonNull(this.preparedStatementFactory, "preparedStatementFactory");
        Objects.requireNonNull(this.identityFilter, "userFilter");
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected String getResourceTable() {
        return this.resourceTable;
    }

    protected String getResourceIdColumn() {
        return this.resourceIdColumn;
    }

    protected String getResourceColumn() {
        return this.resourceColumn;
    }

    protected PreparedStatementFactory<R> getPreparedStatementFactory() {
        return this.preparedStatementFactory;
    }

    @Override
    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    @Override
    public Class<R> getResourceType() {
        return this.resourceType;
    }

    @Override
    public Connection newReadWriteTransaction() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setReadOnly(false);
        connection.setTransactionIsolation(4);
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public final R create(R resource) throws SQLException {
        Objects.requireNonNull(resource, "resource");
        return this.createWithId(resource, UUID.randomUUID());
    }

    @Override
    public R createWithId(R resource, UUID uuid) throws SQLException {
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(uuid, "uuid");
        try (Connection connection = this.dataSource.getConnection();){
            connection.setReadOnly(false);
            R r = this.createWithTransactionAndId(connection, resource, uuid);
            return r;
        }
    }

    @Override
    public R createWithTransactionAndId(Connection connection, R resource, UUID uuid) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(uuid, "uuid");
        if (connection.isReadOnly()) {
            throw new IllegalArgumentException("Connection is read-only");
        }
        R inserted = this.create(connection, resource, uuid);
        logger.debug("{} with ID {} created", (Object)this.resourceTypeName, (Object)inserted.getId());
        return inserted;
    }

    private R create(Connection connection, R resource, UUID uuid) throws SQLException {
        resource = this.copy(resource);
        resource.setIdElement(new IdType(this.resourceTypeName, uuid.toString(), FIRST_VERSION_STRING));
        resource.getMeta().setVersionId(FIRST_VERSION_STRING);
        resource.getMeta().setLastUpdated(new Date());
        try (PreparedStatement statement = connection.prepareStatement(this.preparedStatementFactory.getCreateSql());){
            this.preparedStatementFactory.configureCreateStatement(statement, resource, uuid);
            statement.execute();
        }
        return resource;
    }

    protected abstract R copy(R var1);

    protected R getResource(ResultSet result, int index) throws SQLException {
        String json = result.getString(index);
        return (R)((Resource)this.preparedStatementFactory.getJsonParser().parseResource(this.resourceType, json));
    }

    @Override
    public final Optional<R> read(UUID uuid) throws SQLException, ResourceDeletedException {
        if (uuid == null) {
            return Optional.empty();
        }
        try (Connection connection = this.dataSource.getConnection();){
            Optional<R> optional = this.readWithTransaction(connection, uuid);
            return optional;
        }
    }

    @Override
    public Optional<R> readWithTransaction(Connection connection, UUID uuid) throws SQLException, ResourceDeletedException {
        Objects.requireNonNull(connection, "connection");
        if (uuid == null) {
            return Optional.empty();
        }
        try (PreparedStatement statement = connection.prepareStatement(this.preparedStatementFactory.getReadByIdSql());){
            Optional optional;
            block18: {
                ResultSet result;
                block16: {
                    Optional<R> optional2;
                    block17: {
                        this.preparedStatementFactory.configureReadByIdStatement(statement, uuid);
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block16;
                            LocalDateTime deleted = this.preparedStatementFactory.getReadByIdDeleted(result);
                            if (deleted != null) {
                                long version = this.preparedStatementFactory.getReadByIdVersion(result);
                                logger.debug("{} with IdPart {} found, but marked as deleted", (Object)this.resourceTypeName, (Object)uuid);
                                throw this.newResourceDeletedException(uuid, deleted, version);
                            }
                            logger.debug("{} with IdPart {} found", (Object)this.resourceTypeName, (Object)uuid);
                            optional2 = Optional.of(this.preparedStatementFactory.getReadByIdResource(result));
                            if (result == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                logger.debug("{} with IdPart {} not found", (Object)this.resourceTypeName, (Object)uuid);
                optional = Optional.empty();
                if (result == null) break block18;
                result.close();
            }
            return optional;
        }
    }

    private ResourceDeletedException newResourceDeletedException(UUID uuid, LocalDateTime deleted, long version) {
        return new ResourceDeletedException(new IdType(this.resourceTypeName, uuid.toString(), String.valueOf(version + 1L)), deleted);
    }

    @Override
    public final Optional<R> readVersion(UUID uuid, long version) throws SQLException, ResourceDeletedException {
        if (uuid == null || version < 1L) {
            return Optional.empty();
        }
        try (Connection connection = this.dataSource.getConnection();){
            Optional<R> optional = this.readVersionWithTransaction(connection, uuid, version);
            return optional;
        }
    }

    @Override
    public Optional<R> readVersionWithTransaction(Connection connection, UUID uuid, long version) throws SQLException, ResourceDeletedException {
        Objects.requireNonNull(connection, "connection");
        if (uuid == null || version < 1L) {
            return Optional.empty();
        }
        try (PreparedStatement statement = connection.prepareStatement(this.preparedStatementFactory.getReadByIdAndVersionSql());){
            Optional optional;
            block22: {
                ResultSet result;
                block18: {
                    Optional<R> optional2;
                    block21: {
                        long readVersion;
                        LocalDateTime deleted;
                        block19: {
                            Optional optional3;
                            block20: {
                                this.preparedStatementFactory.configureReadByIdAndVersionStatement(statement, uuid, version);
                                result = statement.executeQuery();
                                try {
                                    if (!result.next()) break block18;
                                    deleted = this.preparedStatementFactory.getReadByIdVersionDeleted(result);
                                    readVersion = this.preparedStatementFactory.getReadByIdVersionVersion(result);
                                    if (deleted != null || readVersion == version) break block19;
                                    logger.debug("{} with IdPart {} and Version {} not found", new Object[]{this.resourceTypeName, uuid, version});
                                    optional3 = Optional.empty();
                                    if (result == null) break block20;
                                }
                                catch (Throwable throwable) {
                                    if (result != null) {
                                        try {
                                            result.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                result.close();
                            }
                            return optional3;
                        }
                        if (deleted != null && readVersion + 1L == version) {
                            logger.debug("{} with IdPart {} and Version {} found, but marked as deleted (delete history entry)", new Object[]{this.resourceTypeName, uuid, version});
                            throw this.newResourceDeletedException(uuid, deleted, readVersion);
                        }
                        logger.debug("{} with IdPart {} and Version {} found", new Object[]{this.resourceTypeName, uuid, version});
                        optional2 = Optional.of(this.preparedStatementFactory.getReadByIdAndVersionResource(result));
                        if (result == null) break block21;
                        result.close();
                    }
                    return optional2;
                }
                logger.debug("{} with IdPart {} and Version {} not found", new Object[]{this.resourceTypeName, uuid, version});
                optional = Optional.empty();
                if (result == null) break block22;
                result.close();
            }
            return optional;
        }
    }

    @Override
    public Optional<R> readIncludingDeleted(UUID uuid) throws SQLException {
        if (uuid == null) {
            return Optional.empty();
        }
        try (Connection connection = this.dataSource.getConnection();){
            Optional<R> optional = this.readIncludingDeletedWithTransaction(connection, uuid);
            return optional;
        }
    }

    @Override
    public Optional<R> readIncludingDeletedWithTransaction(Connection connection, UUID uuid) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        if (uuid == null) {
            return Optional.empty();
        }
        try (PreparedStatement statement = connection.prepareStatement(this.preparedStatementFactory.getReadByIdSql());){
            Optional optional;
            block19: {
                ResultSet result;
                block17: {
                    Optional<R> optional2;
                    block18: {
                        this.preparedStatementFactory.configureReadByIdStatement(statement, uuid);
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block17;
                            if (this.preparedStatementFactory.getReadByIdDeleted(result) != null) {
                                logger.warn("{} with IdPart {} found, but marked as deleted", (Object)this.resourceTypeName, (Object)uuid);
                            } else {
                                logger.debug("{} with IdPart {} found", (Object)this.resourceTypeName, (Object)uuid);
                            }
                            optional2 = Optional.of(this.preparedStatementFactory.getReadByIdResource(result));
                            if (result == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                logger.debug("{} with IdPart {} not found", (Object)this.resourceTypeName, (Object)uuid);
                optional = Optional.empty();
                if (result == null) break block19;
                result.close();
            }
            return optional;
        }
    }

    @Override
    public List<R> readAll() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            List<R> list = this.readAllWithTransaction(connection);
            return list;
        }
    }

    @Override
    public List<R> readAllWithTransaction(Connection connection) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        try (PreparedStatement statement = connection.prepareStatement("SELECT " + this.getResourceColumn() + " FROM current_" + this.getResourceTable());){
            ArrayList<R> arrayList;
            block13: {
                ResultSet result = statement.executeQuery();
                try {
                    ArrayList<R> all = new ArrayList<R>();
                    while (result.next()) {
                        all.add(this.getResource(result, 1));
                    }
                    arrayList = all;
                    if (result == null) break block13;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return arrayList;
        }
    }

    @Override
    public boolean existsNotDeleted(String idString, String versionString) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl = this.existsNotDeletedWithTransaction(connection, idString, versionString);
            return bl;
        }
    }

    @Override
    public boolean existsNotDeletedWithTransaction(Connection connection, String idString, String versionString) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        UUID uuid = this.toUuid(idString);
        if (uuid == null) {
            return false;
        }
        if (versionString == null || versionString.isBlank()) {
            try (PreparedStatement statement = connection.prepareStatement("SELECT deleted IS NOT NULL FROM " + this.resourceTable + " WHERE " + this.resourceIdColumn + " = ? ORDER BY version DESC LIMIT 1");){
                boolean bl;
                block27: {
                    statement.setObject(1, this.preparedStatementFactory.uuidToPgObject(uuid));
                    ResultSet result = statement.executeQuery();
                    try {
                        boolean bl2 = bl = result.next() && !result.getBoolean(1);
                        if (result == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return bl;
            }
        }
        Long version = this.toLong(versionString);
        if (version == null || version < 1L) {
            return false;
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT deleted IS NOT NULL FROM " + this.resourceTable + " WHERE " + this.resourceIdColumn + " = ? AND version = ?");){
            boolean bl;
            block28: {
                statement.setObject(1, this.preparedStatementFactory.uuidToPgObject(uuid));
                statement.setLong(2, version);
                ResultSet result = statement.executeQuery();
                try {
                    boolean bl3 = bl = result.next() && !result.getBoolean(1);
                    if (result == null) break block28;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
    }

    @Override
    public final R update(R resource, Long expectedVersion) throws SQLException, ResourceNotFoundException, ResourceVersionNoMatchException {
        Objects.requireNonNull(resource, "resource");
        try (Connection connection = this.dataSource.getConnection();){
            R r;
            connection.setReadOnly(false);
            connection.setTransactionIsolation(4);
            connection.setAutoCommit(false);
            try {
                R updatedResource = this.updateWithTransaction(connection, resource, expectedVersion);
                connection.commit();
                r = updatedResource;
            }
            catch (Exception e) {
                connection.rollback();
                throw e;
            }
            return r;
        }
    }

    @Override
    public R updateWithTransaction(Connection connection, R resource, Long expectedVersion) throws SQLException, ResourceNotFoundException, ResourceVersionNoMatchException {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(resource, "resource");
        if (connection.isReadOnly()) {
            throw new IllegalArgumentException("Connection is read-only");
        }
        if (connection.getTransactionIsolation() != 4 && connection.getTransactionIsolation() != 8) {
            throw new IllegalArgumentException("Connection transaction isolation not REPEATABLE_READ or SERIALIZABLE");
        }
        if (connection.getAutoCommit()) {
            throw new IllegalArgumentException("Connection transaction is in auto commit mode");
        }
        resource = this.copy(resource);
        LatestVersion latestVersion = this.getLatestVersion(resource, connection);
        if (expectedVersion != null && expectedVersion != latestVersion.version) {
            logger.info("Expected version {} does not match latest version {}", (Object)expectedVersion, (Object)latestVersion.version);
            throw new ResourceVersionNoMatchException(resource.getIdElement().getIdPart(), expectedVersion, latestVersion.version);
        }
        long newVersion = latestVersion.version + 1L;
        R updated = this.update(connection, resource, newVersion);
        logger.debug("{} with IdPart {} updated, new version {}", new Object[]{this.resourceTypeName, updated.getIdElement().getIdPart(), newVersion});
        return updated;
    }

    protected final UUID toUuid(String id) {
        if (id == null) {
            return null;
        }
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected final Long toLong(String version) {
        if (version == null) {
            return null;
        }
        try {
            return Long.parseLong(version);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private R update(Connection connection, R resource, long version) throws SQLException {
        UUID uuid = this.toUuid(resource.getIdElement().getIdPart());
        if (uuid == null) {
            throw new IllegalArgumentException("resource.id is not a UUID");
        }
        resource = this.copy(resource);
        String versionAsString = String.valueOf(version);
        resource.setIdElement(new IdType(this.resourceTypeName, resource.getIdElement().getIdPart(), versionAsString));
        resource.getMeta().setVersionId(versionAsString);
        resource.getMeta().setLastUpdated(new Date());
        try (PreparedStatement statement = connection.prepareStatement(this.preparedStatementFactory.getUpdateNewRowSql());){
            this.preparedStatementFactory.configureUpdateNewRowSqlStatement(statement, uuid, version, resource);
            statement.execute();
        }
        return resource;
    }

    protected final LatestVersion getLatestVersion(R resource, Connection connection) throws SQLException, ResourceNotFoundException {
        UUID uuid = this.toUuid(resource.getIdElement().getIdPart());
        if (uuid == null) {
            throw new ResourceNotFoundException(resource.getId() != null ? resource.getId() : "'null'");
        }
        return this.getLatestVersion(uuid, connection);
    }

    protected final LatestVersion getLatestVersion(UUID uuid, Connection connection) throws SQLException, ResourceNotFoundException {
        if (uuid == null) {
            throw new ResourceNotFoundException("'null'");
        }
        return this.getLatestVersionIfExists(uuid, connection).orElseThrow(() -> new ResourceNotFoundException(uuid.toString()));
    }

    protected final Optional<LatestVersion> getLatestVersionIfExists(UUID uuid, Connection connection) throws SQLException, ResourceNotFoundException {
        if (uuid == null) {
            return Optional.empty();
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT version, deleted IS NOT NULL FROM " + this.resourceTable + " WHERE " + this.resourceIdColumn + " = ? ORDER BY version DESC LIMIT 1");){
            Optional<LatestVersion> optional;
            block17: {
                ResultSet result;
                block15: {
                    Optional<LatestVersion> optional2;
                    block16: {
                        statement.setObject(1, this.preparedStatementFactory.uuidToPgObject(uuid));
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block15;
                            long version = result.getLong(1);
                            boolean deleted = result.getBoolean(2);
                            logger.debug("Latest version for {} with IdPart {} is {}{}", new Object[]{this.resourceTypeName, uuid.toString(), version, deleted ? ", resource marked as deleted" : ""});
                            optional2 = Optional.of(new LatestVersion(version, deleted));
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                logger.debug("{} with IdPart {} not found", (Object)this.resourceTypeName, (Object)uuid.toString());
                optional = Optional.empty();
                if (result == null) break block17;
                result.close();
            }
            return optional;
        }
    }

    @Override
    public final boolean delete(UUID uuid) throws SQLException, ResourceNotFoundException {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setReadOnly(false);
            boolean bl = this.deleteWithTransaction(connection, uuid);
            return bl;
        }
    }

    @Override
    public boolean deleteWithTransaction(Connection connection, UUID uuid) throws SQLException, ResourceNotFoundException {
        return this.delete(connection, uuid);
    }

    protected final boolean delete(Connection connection, UUID uuid) throws SQLException, ResourceNotFoundException {
        Objects.requireNonNull(connection, "connection");
        if (connection.isReadOnly()) {
            throw new IllegalStateException("Connection is read-only");
        }
        if (uuid == null) {
            throw new ResourceNotFoundException("'null'");
        }
        LatestVersion latestVersion = this.getLatestVersion(uuid, connection);
        if (latestVersion.deleted) {
            return false;
        }
        try (PreparedStatement statement = connection.prepareStatement("UPDATE " + this.resourceTable + " SET deleted = ? WHERE " + this.resourceIdColumn + " = ? AND version = (SELECT MAX(version) FROM " + this.resourceTable + " WHERE " + this.resourceIdColumn + " = ?)");){
            statement.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now()));
            statement.setObject(2, this.preparedStatementFactory.uuidToPgObject(uuid));
            statement.setObject(3, this.preparedStatementFactory.uuidToPgObject(uuid));
            statement.execute();
            logger.debug("{} with ID {} marked as deleted", (Object)this.resourceTypeName, (Object)uuid);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public final PartialResult<R> search(DbSearchQuery query) throws SQLException {
        Objects.requireNonNull(query, "query");
        try (Connection connection = this.dataSource.getConnection();){
            PartialResult<R> partialResult = this.searchWithTransaction(connection, query);
            return partialResult;
        }
    }

    @Override
    public PartialResult<R> searchWithTransaction(Connection connection, DbSearchQuery query) throws SQLException {
        Objects.requireNonNull(connection, "connection");
        Objects.requireNonNull(query, "query");
        int total = 0;
        try (PreparedStatement statement = connection.prepareStatement(query.getCountSql());){
            query.modifyStatement(statement, connection::createArrayOf);
            try (ResultSet result = statement.executeQuery();){
                if (result.next()) {
                    total = result.getInt(1);
                }
            }
        }
        ArrayList<R> partialResult = new ArrayList<R>();
        ArrayList<Resource> includes = new ArrayList();
        if (!query.getPageAndCount().isCountOnly(total)) {
            try (PreparedStatement statement = connection.prepareStatement(query.getSearchSql());){
                query.modifyStatement(statement, connection::createArrayOf);
                try (ResultSet result = statement.executeQuery();){
                    ResultSetMetaData metaData = result.getMetaData();
                    while (result.next()) {
                        R resource = this.getResource(result, 1);
                        this.modifySearchResultResource(resource, connection);
                        partialResult.add(resource);
                        for (int columnIndex = 2; columnIndex <= metaData.getColumnCount(); ++columnIndex) {
                            this.getResources(result, columnIndex, includes, connection, query);
                        }
                    }
                }
            }
        }
        includes = includes.stream().map(r -> new ResourceDistinctById(r.getIdElement(), (Resource)r)).distinct().map(ResourceDistinctById::getResource).collect(Collectors.toList());
        return new PartialResult(total, query.getPageAndCount(), partialResult, includes);
    }

    protected void modifySearchResultResource(R resource, Connection connection) throws SQLException {
    }

    private void getResources(ResultSet result, int columnIndex, List<? super Resource> includeResources, Connection connection, DbSearchQuery query) throws SQLException {
        String json = result.getString(columnIndex);
        if (json == null) {
            return;
        }
        JsonArray array = (JsonArray)JsonParser.parseString((String)json);
        for (JsonElement jsonElement : array) {
            IBaseResource resource = this.preparedStatementFactory.getJsonParser().parseResource(jsonElement.toString());
            if (resource instanceof Resource) {
                Resource r = (Resource)resource;
                query.modifyIncludeResource(r, columnIndex, connection);
                includeResources.add((Resource)r);
                continue;
            }
            logger.warn("parsed resouce of type {} not instance of {}, ignoring include resource", (Object)resource.getClass().getName(), (Object)Resource.class.getName());
        }
    }

    @Override
    public final SearchQuery<R> createSearchQuery(Identity identity, PageAndCount pageAndCount) {
        Objects.requireNonNull(identity, "identity");
        return this.doCreateSearchQuery(identity, pageAndCount);
    }

    @Override
    public SearchQuery<R> createSearchQueryWithoutUserFilter(PageAndCount pageAndCount) {
        return this.doCreateSearchQuery(null, pageAndCount);
    }

    private SearchQuery<R> doCreateSearchQuery(Identity identity, PageAndCount pageAndCount) {
        Objects.requireNonNull(pageAndCount, "pageAndCount");
        SearchQuery.SearchQueryBuilder<R> builder = SearchQuery.SearchQueryBuilder.create(this.resourceType, this.getResourceTable(), this.getResourceColumn(), pageAndCount);
        if (identity != null) {
            builder = builder.with(this.identityFilter.apply(identity));
        }
        return builder.with(this.resourceIdFactory).with(this.resourceLastUpdatedFactory).with(this.resourceProfileFactory).with(this.searchParameterFactories).withRevInclude(this.searchRevIncludeParameterFactories).build();
    }

    @Override
    public void deletePermanently(UUID uuid) throws SQLException, ResourceNotFoundException, ResourceNotMarkedDeletedException {
        try (Connection connection = this.permanentDeleteDataSource.getConnection();){
            connection.setReadOnly(false);
            this.deletePermanentlyWithTransaction(connection, uuid);
        }
    }

    @Override
    public void deletePermanentlyWithTransaction(Connection connection, UUID uuid) throws SQLException, ResourceNotFoundException, ResourceNotMarkedDeletedException {
        Objects.requireNonNull(connection, "connection");
        if (connection.isReadOnly()) {
            throw new IllegalStateException("Connection is read-only");
        }
        if (uuid == null) {
            throw new ResourceNotFoundException("'null'");
        }
        LatestVersion latestVersion = this.getLatestVersion(uuid, connection);
        if (!latestVersion.deleted) {
            throw new ResourceNotMarkedDeletedException(uuid.toString());
        }
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM " + this.resourceTable + " WHERE " + this.resourceIdColumn + "= ?");){
            statement.setObject(1, this.preparedStatementFactory.uuidToPgObject(uuid));
            statement.execute();
            logger.debug("{} with ID {} deleted permanently", (Object)this.resourceTypeName, (Object)uuid);
        }
    }

    protected static class LatestVersion {
        final long version;
        final boolean deleted;

        LatestVersion(long version, boolean deleted) {
            this.version = version + (long)(deleted ? 1 : 0);
            this.deleted = deleted;
        }
    }

    private static final class ResourceDistinctById {
        final IdType id;
        final Resource resource;

        ResourceDistinctById(IdType id, Resource resource) {
            this.id = id;
            this.resource = resource;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceDistinctById other = (ResourceDistinctById)obj;
            return Objects.equals(this.id, other.id);
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

