/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.fhir.event.Event;
import dev.dsf.fhir.event.EventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TransactionEventHandler
implements EventHandler {
    private final List<Event> cachedEvents = new ArrayList<Event>();
    private final EventHandler commitDelegate;
    private final EventHandler delegate;

    public TransactionEventHandler(EventHandler commitDelegate, EventHandler delegate) {
        this.commitDelegate = Objects.requireNonNull(commitDelegate, "commitDelegate");
        this.delegate = delegate;
    }

    @Override
    public void handleEvent(Event event) {
        this.cachedEvents.add(event);
        if (this.delegate != null) {
            this.delegate.handleEvent(event);
        }
    }

    @Override
    public void handleEvents(List<Event> events) {
        this.cachedEvents.addAll(events);
        if (this.delegate != null) {
            this.delegate.handleEvents(events);
        }
    }

    public void commitEvents() {
        this.commitDelegate.handleEvents(this.cachedEvents);
    }
}

