/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.command.ReferencesHelper;
import dev.dsf.fhir.help.ResponseGenerator;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceResolver;
import dev.dsf.fhir.service.ResourceReference;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.sql.Connection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;

public final class ReferencesHelperImpl<R extends Resource>
implements ReferencesHelper<R> {
    private final int index;
    private final Identity identity;
    private final R resource;
    private final String serverBase;
    private final ReferenceExtractor referenceExtractor;
    private final ReferenceResolver referenceResolver;
    private final ResponseGenerator responseGenerator;

    public ReferencesHelperImpl(int index, Identity identity, R resource, String serverBase, ReferenceExtractor referenceExtractor, ReferenceResolver referenceResolver, ResponseGenerator responseGenerator) {
        this.index = index;
        this.identity = identity;
        this.resource = resource;
        this.serverBase = serverBase;
        this.referenceExtractor = referenceExtractor;
        this.referenceResolver = referenceResolver;
        this.responseGenerator = responseGenerator;
    }

    @Override
    public void resolveTemporaryAndConditionalReferencesOrLiteralInternalRelatedArtifactOrAttachmentUrls(Map<String, IdType> idTranslationTable, Connection connection) throws WebApplicationException {
        this.referenceExtractor.getReferences(this.resource).filter(ref -> this.referenceResolver.referenceCanBeResolved((ResourceReference)ref, connection)).forEach(ref -> {
            Optional<OperationOutcome> outcome = this.resolveTemporaryOrConditionalReferenceOrLiteralInternalRelatedArtifactOrAttachmentUrl((ResourceReference)ref, idTranslationTable, connection);
            if (outcome.isPresent()) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)outcome.get()).build();
                throw new WebApplicationException(response);
            }
        });
    }

    private Optional<OperationOutcome> resolveTemporaryOrConditionalReferenceOrLiteralInternalRelatedArtifactOrAttachmentUrl(ResourceReference reference, Map<String, IdType> idTranslationTable, Connection connection) {
        return switch (reference.getType(this.serverBase)) {
            case ResourceReference.ReferenceType.TEMPORARY -> this.resolveTemporary(reference, idTranslationTable, () -> ((Reference)reference.getReference()).getReference(), arg_0 -> ((Reference)reference.getReference()).setReferenceElement(arg_0));
            case ResourceReference.ReferenceType.RELATED_ARTEFACT_TEMPORARY_URL -> this.resolveTemporary(reference, idTranslationTable, () -> ((RelatedArtifact)reference.getRelatedArtifact()).getUrl(), this.newIdToAbsoluteUrl(arg_0 -> ((RelatedArtifact)reference.getRelatedArtifact()).setUrl(arg_0)));
            case ResourceReference.ReferenceType.ATTACHMENT_TEMPORARY_URL -> this.resolveTemporary(reference, idTranslationTable, () -> ((Attachment)reference.getAttachment()).getUrl(), this.newIdToAbsoluteUrl(arg_0 -> ((Attachment)reference.getAttachment()).setUrl(arg_0)));
            case ResourceReference.ReferenceType.CONDITIONAL -> this.resolveConditional(reference, connection, target -> reference.getReference().setReferenceElement((IIdType)new IdType(target.getResourceType().name(), target.getIdElement().getIdPart())));
            case ResourceReference.ReferenceType.RELATED_ARTEFACT_CONDITIONAL_URL -> this.resolveConditional(reference, connection, this.targetToAbsoluteUrl(arg_0 -> ((RelatedArtifact)reference.getRelatedArtifact()).setUrl(arg_0)));
            case ResourceReference.ReferenceType.ATTACHMENT_CONDITIONAL_URL -> this.resolveConditional(reference, connection, this.targetToAbsoluteUrl(arg_0 -> ((Attachment)reference.getAttachment()).setUrl(arg_0)));
            case ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_INTERNAL_URL -> this.resolveLiteralInternalUrl(() -> ((ResourceReference)reference).getRelatedArtifact(), RelatedArtifact::getUrl, RelatedArtifact::setUrl);
            case ResourceReference.ReferenceType.ATTACHMENT_LITERAL_INTERNAL_URL -> this.resolveLiteralInternalUrl(() -> ((ResourceReference)reference).getAttachment(), Attachment::getUrl, Attachment::setUrl);
            default -> Optional.empty();
        };
    }

    private Consumer<IdType> newIdToAbsoluteUrl(Consumer<String> absoluteUrlConsumer) {
        return newId -> {
            String absoluteUrl = newId.withServerBase(this.serverBase, newId.getResourceType()).getValue();
            absoluteUrlConsumer.accept(absoluteUrl);
        };
    }

    private Consumer<Resource> targetToAbsoluteUrl(Consumer<String> absoluteUrlConsumer) {
        return target -> {
            IdType newId = new IdType(target.getResourceType().name(), target.getIdElement().getIdPart());
            String absoluteUrl = newId.withServerBase(this.serverBase, newId.getResourceType()).getValue();
            absoluteUrlConsumer.accept(absoluteUrl);
        };
    }

    private Optional<OperationOutcome> resolveTemporary(ResourceReference reference, Map<String, IdType> idTranslationTable, Supplier<String> temporaryIdSupplier, Consumer<IdType> newIdConsumer) {
        IdType newId = idTranslationTable.get(temporaryIdSupplier.get());
        if (newId != null) {
            newIdConsumer.accept(newId);
            return Optional.empty();
        }
        return Optional.of(this.responseGenerator.unknownReference((Resource)this.resource, reference, this.index));
    }

    private Optional<OperationOutcome> resolveConditional(ResourceReference reference, Connection connection, Consumer<Resource> targetConsumer) {
        Optional<Resource> resolvedResource = this.referenceResolver.resolveReference(this.identity, reference, connection);
        if (resolvedResource.isPresent()) {
            Resource target = resolvedResource.get();
            targetConsumer.accept(target);
            return Optional.empty();
        }
        return Optional.of(this.responseGenerator.referenceTargetNotFoundLocallyByCondition(this.index, (Resource)this.resource, reference));
    }

    private <T extends Type> Optional<OperationOutcome> resolveLiteralInternalUrl(Supplier<T> element, Function<T, String> oldUrlValue, BiConsumer<T, String> newAbsoluteUrlConsumer) {
        Type type = (Type)element.get();
        if (type != null) {
            IdType newId = new IdType(oldUrlValue.apply(type));
            String absoluteUrl = newId.withServerBase(this.serverBase, newId.getResourceType()).getValue();
            newAbsoluteUrlConsumer.accept(type, absoluteUrl);
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public void resolveLogicalReferences(Connection connection) throws WebApplicationException {
        this.referenceExtractor.getReferences(this.resource).filter(ref -> ResourceReference.ReferenceType.LOGICAL.equals((Object)ref.getType(this.serverBase))).filter(ref -> this.referenceResolver.referenceCanBeResolved((ResourceReference)ref, connection)).forEach(ref -> {
            Optional<OperationOutcome> outcome = this.resolveLogicalReference((ResourceReference)ref, connection);
            if (outcome.isPresent()) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)outcome.get()).build();
                throw new WebApplicationException(response);
            }
        });
    }

    private Optional<OperationOutcome> resolveLogicalReference(ResourceReference reference, Connection connection) {
        Optional<Resource> resolvedResource = this.referenceResolver.resolveReference(this.identity, reference, connection);
        if (resolvedResource.isPresent()) {
            Resource target = resolvedResource.get();
            reference.getReference().setReferenceElement((IIdType)new IdType(target.getResourceType().name(), target.getIdElement().getIdPart()));
            return Optional.empty();
        }
        return Optional.of(this.responseGenerator.referenceTargetNotFoundLocallyByIdentifier(this.index, (Resource)this.resource, reference));
    }

    @Override
    public void checkReferences(Map<String, IdType> idTranslationTable, Connection connection, Predicate<ResourceReference> checkReference) throws WebApplicationException {
        this.referenceExtractor.getReferences(this.resource).filter(checkReference).filter(ref -> this.referenceResolver.referenceCanBeChecked((ResourceReference)ref, connection)).forEach(ref -> {
            Optional<OperationOutcome> outcome = this.checkReference((ResourceReference)ref, connection);
            if (outcome.isPresent()) {
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)outcome.get()).build();
                throw new WebApplicationException(response);
            }
        });
    }

    private Optional<OperationOutcome> checkReference(ResourceReference reference, Connection connection) throws WebApplicationException {
        return switch (reference.getType(this.serverBase)) {
            case ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_INTERNAL_URL, ResourceReference.ReferenceType.ATTACHMENT_LITERAL_INTERNAL_URL, ResourceReference.ReferenceType.LITERAL_INTERNAL -> this.referenceResolver.checkLiteralInternalReference((Resource)this.resource, reference, connection, this.index);
            case ResourceReference.ReferenceType.LITERAL_EXTERNAL, ResourceReference.ReferenceType.RELATED_ARTEFACT_LITERAL_EXTERNAL_URL, ResourceReference.ReferenceType.ATTACHMENT_LITERAL_EXTERNAL_URL -> this.referenceResolver.checkLiteralExternalReference((Resource)this.resource, reference, this.index);
            case ResourceReference.ReferenceType.LOGICAL -> this.referenceResolver.checkLogicalReference(this.identity, (Resource)this.resource, reference, connection, this.index);
            case ResourceReference.ReferenceType.RELATED_ARTEFACT_UNKNOWN_URL, ResourceReference.ReferenceType.ATTACHMENT_UNKNOWN_URL -> Optional.empty();
            case ResourceReference.ReferenceType.UNKNOWN -> Optional.of(this.responseGenerator.unknownReference((Resource)this.resource, reference, this.index));
            default -> Optional.of(this.responseGenerator.unknownReference((Resource)this.resource, reference, this.index));
        };
    }
}

