/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao.command;

import dev.dsf.fhir.dao.command.Command;
import dev.dsf.fhir.dao.command.CreateCommand;
import dev.dsf.fhir.dao.command.DeleteCommand;
import dev.dsf.fhir.dao.command.ModifyingCommand;
import dev.dsf.fhir.dao.command.ReadCommand;
import dev.dsf.fhir.dao.command.UpdateCommand;
import dev.dsf.fhir.help.ExceptionHandler;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbstractCommandList {
    private static final Logger audit = LoggerFactory.getLogger((String)"dsf-audit-logger");
    protected final DataSource dataSource;
    protected final ExceptionHandler exceptionHandler;
    protected final List<Command> commands = new ArrayList<Command>();
    protected final boolean hasModifyingCommands;

    protected AbstractCommandList(DataSource dataSource, ExceptionHandler exceptionHandler, List<? extends Command> commands) {
        this.dataSource = dataSource;
        this.exceptionHandler = exceptionHandler;
        if (commands != null) {
            this.commands.addAll(commands);
        }
        this.hasModifyingCommands = AbstractCommandList.hasModifyingCommands(commands);
    }

    private static boolean hasModifyingCommands(List<? extends Command> commands) {
        return commands != null && commands.stream().anyMatch(c -> c instanceof ModifyingCommand);
    }

    protected void auditLogResult(Command command, Bundle.BundleEntryComponent result) {
        String resultOutcome;
        String string = resultOutcome = this.failed(result) ? "failed" : "successful";
        if (command instanceof DeleteCommand) {
            audit.info("Delete of {} for identity '{}' via bundle at index {} {}, status: {}", new Object[]{command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex(), resultOutcome, result.getResponse().getStatus()});
        } else if (command instanceof CreateCommand) {
            audit.info("Create of {} for identity '{}' via bundle at index {} {}, status: {}", new Object[]{command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex(), resultOutcome, result.getResponse().getStatus()});
        } else if (command instanceof UpdateCommand) {
            audit.info("Update of {} for identity '{}' via bundle at index {} {}, status: {}", new Object[]{command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex(), resultOutcome, result.getResponse().getStatus()});
        } else if (command instanceof ReadCommand) {
            audit.info("{} of {} for identity '{}' via bundle at index {} {}, status: {}", new Object[]{((ReadCommand)command).isSearch() ? "Search" : "Read", command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex(), resultOutcome, result.getResponse().getStatus()});
        }
    }

    protected void auditLogAbbort(Command command) {
        if (command instanceof DeleteCommand) {
            audit.info("Delete of {} for identity '{}' via bundle at index {} abborted", new Object[]{command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex()});
        } else if (command instanceof CreateCommand) {
            audit.info("Create of {} for identity '{}' via bundle at index {} abborted", new Object[]{command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex()});
        } else if (command instanceof UpdateCommand) {
            audit.info("Update of {} for identity '{}' via bundle at index {} abborted", new Object[]{command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex()});
        } else if (command instanceof ReadCommand) {
            ReadCommand r = (ReadCommand)command;
            audit.info("{} of {} for identity '{}' via bundle at index {} abborted", new Object[]{r.isSearch() ? "Search" : "Read", command.getResourceTypeName(), command.getIdentity().getName(), command.getIndex()});
        }
    }

    private boolean failed(Bundle.BundleEntryComponent result) {
        String status;
        if (result != null && result.hasResponse() && result.getResponse().hasStatus() && (status = result.getResponse().getStatus()).length() >= 3 && status.matches("[0-9]{3}.*")) {
            return !Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.fromStatusCode((int)Integer.parseInt(status.substring(0, 3))).getFamily());
        }
        return false;
    }

    protected Bundle.BundleEntryComponent toEntry(Exception exception) {
        WebApplicationException w;
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryResponseComponent response = entry.getResponse();
        if (!(exception instanceof WebApplicationException) || !((w = (WebApplicationException)exception).getResponse().getEntity() instanceof OperationOutcome)) {
            exception = this.exceptionHandler.internalServerErrorBundleBatch(exception);
        }
        Response httpResponse = ((WebApplicationException)exception).getResponse();
        response.setStatus(httpResponse.getStatusInfo().getStatusCode() + " " + httpResponse.getStatusInfo().getReasonPhrase());
        response.setOutcome((Resource)((OperationOutcome)httpResponse.getEntity()));
        return entry;
    }
}

