/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.dao;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.dao.exception.ResourceDeletedException;
import dev.dsf.fhir.dao.exception.ResourceNotFoundException;
import dev.dsf.fhir.dao.exception.ResourceNotMarkedDeletedException;
import dev.dsf.fhir.dao.exception.ResourceVersionNoMatchException;
import dev.dsf.fhir.search.DbSearchQuery;
import dev.dsf.fhir.search.PageAndCount;
import dev.dsf.fhir.search.PartialResult;
import dev.dsf.fhir.search.SearchQuery;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hl7.fhir.r4.model.Resource;

public interface ResourceDao<R extends Resource> {
    public static final int FIRST_VERSION = 1;
    public static final String FIRST_VERSION_STRING = String.valueOf(1);

    public String getResourceTypeName();

    public Class<R> getResourceType();

    public Connection newReadWriteTransaction() throws SQLException;

    public R create(R var1) throws SQLException;

    public R createWithId(R var1, UUID var2) throws SQLException;

    public R createWithTransactionAndId(Connection var1, R var2, UUID var3) throws SQLException;

    public Optional<R> read(UUID var1) throws SQLException, ResourceDeletedException;

    public Optional<R> readWithTransaction(Connection var1, UUID var2) throws SQLException, ResourceDeletedException;

    public Optional<R> readVersion(UUID var1, long var2) throws SQLException, ResourceDeletedException;

    public Optional<R> readVersionWithTransaction(Connection var1, UUID var2, long var3) throws SQLException, ResourceDeletedException;

    public Optional<R> readIncludingDeleted(UUID var1) throws SQLException;

    public Optional<R> readIncludingDeletedWithTransaction(Connection var1, UUID var2) throws SQLException;

    public List<R> readAll() throws SQLException;

    public List<R> readAllWithTransaction(Connection var1) throws SQLException;

    public boolean existsNotDeleted(String var1, String var2) throws SQLException;

    public boolean existsNotDeletedWithTransaction(Connection var1, String var2, String var3) throws SQLException;

    default public R update(R resource) throws SQLException, ResourceNotFoundException {
        try {
            return this.update(resource, null);
        }
        catch (ResourceVersionNoMatchException e) {
            throw new RuntimeException(e);
        }
    }

    public R update(R var1, Long var2) throws SQLException, ResourceNotFoundException, ResourceVersionNoMatchException;

    default public R updateWithTransaction(Connection connection, R resource) throws SQLException, ResourceNotFoundException {
        try {
            return this.updateWithTransaction(connection, resource, null);
        }
        catch (ResourceVersionNoMatchException e) {
            throw new RuntimeException(e);
        }
    }

    public R updateWithTransaction(Connection var1, R var2, Long var3) throws SQLException, ResourceNotFoundException, ResourceVersionNoMatchException;

    public boolean delete(UUID var1) throws SQLException, ResourceNotFoundException;

    public boolean deleteWithTransaction(Connection var1, UUID var2) throws SQLException, ResourceNotFoundException;

    public PartialResult<R> search(DbSearchQuery var1) throws SQLException;

    public PartialResult<R> searchWithTransaction(Connection var1, DbSearchQuery var2) throws SQLException;

    public SearchQuery<R> createSearchQuery(Identity var1, PageAndCount var2);

    public SearchQuery<R> createSearchQueryWithoutUserFilter(PageAndCount var1);

    public void deletePermanently(UUID var1) throws SQLException, ResourceNotFoundException, ResourceNotMarkedDeletedException;

    public void deletePermanentlyWithTransaction(Connection var1, UUID var2) throws SQLException, ResourceNotFoundException, ResourceNotMarkedDeletedException;
}

