/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractMetaTagAuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.StructureDefinitionDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureDefinitionAuthorizationRule
extends AbstractMetaTagAuthorizationRule<StructureDefinition, StructureDefinitionDao> {
    private static final Logger logger = LoggerFactory.getLogger(StructureDefinitionAuthorizationRule.class);

    public StructureDefinitionAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(StructureDefinition.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
    }

    @Override
    protected Optional<String> newResourceOkForCreate(Connection connection, Identity identity, StructureDefinition newResource) {
        return this.newResourceOk(connection, newResource);
    }

    @Override
    protected Optional<String> newResourceOkForUpdate(Connection connection, Identity identity, StructureDefinition newResource) {
        return this.newResourceOk(connection, newResource);
    }

    private Optional<String> newResourceOk(Connection connection, StructureDefinition newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (newResource.hasStatus()) {
            if (!EnumSet.of(Enumerations.PublicationStatus.DRAFT, Enumerations.PublicationStatus.ACTIVE, Enumerations.PublicationStatus.RETIRED).contains(newResource.getStatus())) {
                errors.add("StructureDefinition.status not one of DRAFT, ACTIVE or RETIRED");
            }
        } else {
            errors.add("StructureDefinition.status not defined");
        }
        if (!newResource.hasUrl()) {
            errors.add("StructureDefinition.url not defined");
        }
        if (!newResource.hasVersion()) {
            errors.add("StructureDefinition.version not defined");
        }
        if (!this.hasValidReadAccessTag(connection, (Resource)newResource)) {
            errors.add("missing valid read access tag");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    @Override
    protected boolean resourceExists(Connection connection, StructureDefinition newResource) {
        try {
            return ((StructureDefinitionDao)this.getDao()).readByUrlAndVersionWithTransaction(connection, newResource.getUrl(), newResource.getVersion()).map(s -> true).orElse(false);
        }
        catch (SQLException e) {
            logger.debug("Error while searching for StructureDefinition", (Throwable)e);
            logger.warn("Error while searching for StructureDefinition: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return false;
        }
    }

    @Override
    protected boolean modificationsOk(Connection connection, StructureDefinition oldResource, StructureDefinition newResource) {
        return oldResource.getUrl().equals(newResource.getUrl()) && oldResource.getVersion().equals(newResource.getVersion());
    }
}

