/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authorization;

import dev.dsf.common.auth.conf.Identity;
import dev.dsf.fhir.authentication.OrganizationProvider;
import dev.dsf.fhir.authorization.AbstractMetaTagAuthorizationRule;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.dao.ProvenanceDao;
import dev.dsf.fhir.dao.provider.DaoProvider;
import dev.dsf.fhir.help.ParameterConverter;
import dev.dsf.fhir.service.ReferenceResolver;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Resource;

public class ProvenanceAuthorizationRule
extends AbstractMetaTagAuthorizationRule<Provenance, ProvenanceDao> {
    public ProvenanceAuthorizationRule(DaoProvider daoProvider, String serverBase, ReferenceResolver referenceResolver, OrganizationProvider organizationProvider, ReadAccessHelper readAccessHelper, ParameterConverter parameterConverter) {
        super(Provenance.class, daoProvider, serverBase, referenceResolver, organizationProvider, readAccessHelper, parameterConverter);
    }

    @Override
    protected Optional<String> newResourceOkForCreate(Connection connection, Identity identity, Provenance newResource) {
        return this.newResourceOk(connection, newResource);
    }

    @Override
    protected Optional<String> newResourceOkForUpdate(Connection connection, Identity identity, Provenance newResource) {
        return this.newResourceOk(connection, newResource);
    }

    private Optional<String> newResourceOk(Connection connection, Provenance newResource) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.hasValidReadAccessTag(connection, (Resource)newResource)) {
            errors.add("Provenance is missing valid read access tag");
        }
        if (errors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(errors.stream().collect(Collectors.joining(", ")));
    }

    @Override
    protected boolean resourceExists(Connection connection, Provenance newResource) {
        return false;
    }

    @Override
    protected boolean modificationsOk(Connection connection, Provenance oldResource, Provenance newResource) {
        return true;
    }
}

