/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.authentication;

import dev.dsf.common.auth.conf.AbstractIdentityProvider;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.IdentityProvider;
import dev.dsf.common.auth.conf.OrganizationIdentityImpl;
import dev.dsf.common.auth.conf.PractitionerIdentityImpl;
import dev.dsf.common.auth.conf.RoleConfig;
import dev.dsf.fhir.authentication.FhirServerRole;
import dev.dsf.fhir.authentication.OrganizationProvider;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class IdentityProviderImpl
extends AbstractIdentityProvider
implements IdentityProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(IdentityProviderImpl.class);
    private final OrganizationProvider organizationProvider;
    private final String localOrganizationIdentifierValue;

    public IdentityProviderImpl(RoleConfig roleConfig, OrganizationProvider organizationProvider, String localOrganizationIdentifierValue) {
        super(roleConfig);
        this.organizationProvider = organizationProvider;
        this.localOrganizationIdentifierValue = localOrganizationIdentifierValue;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.organizationProvider, "organizationProvider");
        Objects.requireNonNull(this.localOrganizationIdentifierValue, "localOrganizationIdentifierValue");
    }

    protected Optional<Organization> getLocalOrganization() {
        return this.organizationProvider.getLocalOrganization();
    }

    public Identity getIdentity(X509Certificate[] certificates) {
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        String thumbprint = this.getThumbprint(certificates[0]);
        Optional<Organization> organization = this.organizationProvider.getOrganization(certificates[0]);
        if (organization.isPresent()) {
            boolean localOrganization = this.isLocalOrganization(organization.get());
            if (localOrganization) {
                return new OrganizationIdentityImpl(true, organization.get(), FhirServerRole.LOCAL_ORGANIZATION, certificates[0]);
            }
            return new OrganizationIdentityImpl(false, organization.get(), FhirServerRole.REMOTE_ORGANIZATION, certificates[0]);
        }
        Optional practitioner = this.toPractitioner(certificates[0]);
        Optional<Organization> localOrganization = this.organizationProvider.getLocalOrganization();
        if (practitioner.isPresent() && localOrganization.isPresent()) {
            Practitioner p = (Practitioner)practitioner.get();
            Organization o = localOrganization.get();
            return new PractitionerIdentityImpl(o, (Collection)this.getDsfRolesFor(p, thumbprint, null, null), certificates[0], p, (Collection)this.getPractitionerRolesFor(p, thumbprint, null, null), null);
        }
        logger.warn("Certificate with thumbprint '{}' for '{}' unknown, not part of allowlist and not configured as local user or local organization", (Object)thumbprint, (Object)this.getDn(certificates[0]));
        return null;
    }

    private boolean isLocalOrganization(Organization organization) {
        return organization != null && organization.getIdentifier().stream().filter(i -> i != null).filter(i -> "http://dsf.dev/sid/organization-identifier".equals(i.getSystem())).anyMatch(i -> this.localOrganizationIdentifierValue.equals(i.getValue()));
    }
}

