/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.ui.theme.Theme;
import dev.dsf.fhir.adapter.ElementId;
import dev.dsf.fhir.adapter.ThymeleafContext;
import dev.dsf.fhir.adapter.ThymeleafTemplateService;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.util.HtmlUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateServiceImpl
implements ThymeleafTemplateService,
InitializingBean {
    private static final String RESOURCE_NAMES = "Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|DomainResource|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|Resource|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SubstanceSpecification|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription";
    private static final String UUID = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
    private static final Pattern URL_PATTERN = Pattern.compile("(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_.|]");
    private static final Pattern XML_REFERENCE_UUID_PATTERN = Pattern.compile("&lt;reference value=\"((Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|DomainResource|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|Resource|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SubstanceSpecification|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\"/&gt;");
    private static final Pattern JSON_REFERENCE_UUID_PATTERN = Pattern.compile("\"reference\": \"((Account|ActivityDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|CatalogEntry|ChargeItem|ChargeItemDefinition|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceDefinition|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|DomainResource|EffectEvidenceSynthesis|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|InsurancePlan|Invoice|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProduct|MedicinalProductAuthorization|MedicinalProductContraindication|MedicinalProductIndication|MedicinalProductIngredient|MedicinalProductInteraction|MedicinalProductManufactured|MedicinalProductPackaged|MedicinalProductPharmaceutical|MedicinalProductUndesirableEffect|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionOrder|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RelatedPerson|RequestGroup|ResearchDefinition|ResearchElementDefinition|ResearchStudy|ResearchSubject|Resource|RiskAssessment|RiskEvidenceSynthesis|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|Substance|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SubstanceSpecification|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestReport|TestScript|ValueSet|VerificationResult|VisionPrescription)/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\",");
    private static final Pattern XML_ID_UUID_AND_VERSION_PATTERN = Pattern.compile("&lt;id value=\"([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\"/&gt;\\n([ ]*)&lt;meta&gt;\\n([ ]*)&lt;versionId value=\"([0-9]+)\"/&gt;");
    private static final Pattern JSON_ID_UUID_AND_VERSION_PATTERN = Pattern.compile("\"id\": \"([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\",\\n([ ]*)\"meta\": \\{\\n([ ]*)\"versionId\": \"([0-9]+)\",");
    private final String serverBaseUrl;
    private final Theme theme;
    private final FhirContext fhirContext;
    private final boolean modCssExists;
    private final Map<Class<? extends Resource>, List<ThymeleafContext>> contextsByResourceType;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final TemplateEngine templateEngine = new TemplateEngine();

    public ThymeleafTemplateServiceImpl(String serverBaseUrl, Theme theme, FhirContext fhirContext, List<? extends ThymeleafContext> contexts, boolean cacheEnabled, boolean modCssExists) {
        this.serverBaseUrl = serverBaseUrl;
        this.theme = theme;
        this.fhirContext = fhirContext;
        this.modCssExists = modCssExists;
        this.contextsByResourceType = contexts == null ? Map.of() : contexts.stream().collect(Collectors.groupingBy(ThymeleafContext::getResourceType));
        ClassLoaderTemplateResolver resolver = new ClassLoaderTemplateResolver();
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setPrefix("/template/");
        resolver.setSuffix(".html");
        resolver.setCacheable(cacheEnabled);
        this.templateEngine.setTemplateResolver((ITemplateResolver)resolver);
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.serverBaseUrl, "serverBaseUrl");
        Objects.requireNonNull(this.fhirContext, "fhirContext");
    }

    @Override
    public void writeTo(Resource resource, Class<?> type, MediaType mediaType, UriInfo uriInfo, SecurityContext securityContext, OutputStream outputStream) throws IOException {
        String string;
        Context context = new Context();
        context.setVariable("basePath", (Object)this.getServerBaseUrlPathWithLeadingSlash());
        context.setVariable("modCssExists", (Object)this.modCssExists);
        context.setVariable("theme", this.theme == null ? null : this.theme.toString());
        context.setVariable("title", (Object)this.getTitle(uriInfo));
        context.setVariable("heading", (Object)this.getHeading(resource, uriInfo));
        Principal principal = securityContext.getUserPrincipal();
        if (principal instanceof Identity) {
            Identity i = (Identity)principal;
            string = i.getDisplayName();
        } else {
            string = null;
        }
        context.setVariable("username", string);
        context.setVariable("openid", (Object)"OPENID".equals(securityContext.getAuthenticationScheme()));
        context.setVariable("xml", (Object)this.toXml(mediaType, resource));
        context.setVariable("json", (Object)this.toJson(mediaType, resource));
        context.setVariable("resourceId", (Object)ElementId.from(resource));
        this.getContext(type, uriInfo).ifPresent(tContext -> {
            context.setVariable("htmlFragment", (Object)tContext.getHtmlFragment());
            tContext.setVariables((arg_0, arg_1) -> ((Context)context).setVariable(arg_0, arg_1), resource);
        });
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        this.templateEngine.process("main", (IContext)context, (Writer)writer);
    }

    private Optional<ThymeleafContext> getContext(Class<?> type, UriInfo uriInfo) {
        return this.contextsByResourceType.getOrDefault(type, List.of()).stream().filter(g -> {
            Optional<String> lastSegment = uriInfo.getPathSegments().stream().filter(Objects::nonNull).map(PathSegment::getPath).filter(Objects::nonNull).filter(s -> !s.isBlank()).reduce((first, second) -> second);
            return lastSegment.map(g::isResourceSupported).orElse(false);
        }).findFirst();
    }

    private String getServerBaseUrlPathWithLeadingSlash() {
        try {
            return new URL(this.serverBaseUrl).getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String getTitle(UriInfo uriInfo) {
        if (uriInfo == null || uriInfo.getPath() == null || uriInfo.getPath().isBlank()) {
            return "DSF";
        }
        if (uriInfo.getPath().endsWith("/")) {
            return "DSF: " + HtmlUtils.htmlEscape((String)uriInfo.getPath().substring(0, uriInfo.getPath().length() - 1));
        }
        return "DSF: " + HtmlUtils.htmlEscape((String)uriInfo.getPath());
    }

    private String getHeading(Resource resource, UriInfo uriInfo) {
        URI uri = this.getResourceUri(resource, uriInfo);
        String[] pathSegments = uri.getPath().split("/");
        Object u = this.serverBaseUrl;
        StringBuilder heading = new StringBuilder("<a href=\"" + (String)u + "/\" title=\"Open " + (String)u + "\">" + (String)u + "</a>");
        String[] basePathSegments = this.getServerBaseUrlPathWithLeadingSlash().split("/");
        for (int i = basePathSegments.length; i < pathSegments.length; ++i) {
            String pathSegment = HtmlUtils.htmlEscape((String)pathSegments[i]);
            u = (String)u + "/" + pathSegment;
            heading.append("<a href=\"" + (String)u + "\" title=\"Open " + (String)u + "\">/" + pathSegment + "</a>");
        }
        if (uri.getQuery() != null) {
            String queryValue = HtmlUtils.htmlEscape((String)uri.getQuery());
            u = (String)u + "?" + queryValue;
            heading.append("<a href=\"" + (String)u + "\" title=\"Open " + (String)u + "\">?" + queryValue.replace("&amp;", "<wbr>&amp;").replace("-", "&#8209;") + "</a>");
        } else if (uriInfo.getQueryParameters().containsKey((Object)"_summary")) {
            String summaryValue = HtmlUtils.htmlEscape((String)((String)uriInfo.getQueryParameters().getFirst((Object)"_summary")));
            u = (String)u + "?_summary=" + summaryValue;
            heading.append("<a href=\"" + (String)u + "\" title=\"Open " + (String)u + "\">?_summary=" + summaryValue + "</a>");
        }
        return heading.toString();
    }

    private URI getResourceUri(Resource resource, UriInfo uriInfo) {
        return this.getResourceUrlString(resource, uriInfo).map(this::toURI).orElse(this.toURI(this.serverBaseUrl + "/" + uriInfo.getPath()));
    }

    private URI toURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getResourceUrlString(Resource resource, UriInfo uriInfo) {
        if (resource.getIdElement().hasIdPart()) {
            if (!uriInfo.getPath().contains("_history")) {
                return Optional.of(String.format("%s/%s/%s", this.serverBaseUrl, resource.getIdElement().getResourceType(), resource.getIdElement().getIdPart()));
            }
            return Optional.of(String.format("%s/%s/%s/_history/%s", this.serverBaseUrl, resource.getIdElement().getResourceType(), resource.getIdElement().getIdPart(), resource.getIdElement().getVersionIdPart()));
        }
        if (resource instanceof Bundle) {
            Bundle b = (Bundle)resource;
            if (!resource.getIdElement().hasIdPart()) {
                return b.getLink().stream().filter(c -> "self".equals(c.getRelation())).findFirst().map(Bundle.BundleLinkComponent::getUrl);
            }
        }
        return Optional.empty();
    }

    private String toXml(MediaType mediaType, Resource resource) throws IOException {
        IParser parser = this.getParser(mediaType, () -> ((FhirContext)this.fhirContext).newXmlParser());
        String content = parser.encodeResourceToString((IBaseResource)resource);
        content = content.replace("&amp;", "&amp;amp;").replace("&apos;", "&amp;apos;").replace("&gt;", "&amp;gt;").replace("&lt;", "&amp;lt;").replace("&quot;", "&amp;quot;");
        content = this.simplifyXml(content);
        content = content.replace("<", "&lt;").replace(">", "&gt;");
        Matcher versionMatcher = XML_ID_UUID_AND_VERSION_PATTERN.matcher(content);
        content = versionMatcher.replaceAll(result -> {
            Optional<String> resourceName = this.getResourceName(resource, result.group(1));
            return resourceName.map(rN -> "&lt;id value=\"<a href=\"" + rN + "/" + result.group(1) + "\">" + result.group(1) + "</a>\"/&gt;\n" + result.group(2) + "&lt;meta&gt;\n" + result.group(3) + "&lt;versionId value=\"<a href=\"" + rN + "/" + result.group(1) + "/_history/" + result.group(4) + "\">" + result.group(4) + "</a>\"/&gt;").orElse(result.group(0));
        });
        Matcher urlMatcher = URL_PATTERN.matcher(content);
        content = urlMatcher.replaceAll(result -> "<a href=\"" + result.group().replace("&amp;amp;", "&amp;").replace("&amp;apos;", "&apos;").replace("&amp;gt;", "&gt;").replace("&amp;lt;", "&lt;").replace("&amp;quot;", "&quot;") + "\">" + result.group() + "</a>");
        Matcher referenceUuidMatcher = XML_REFERENCE_UUID_PATTERN.matcher(content);
        content = referenceUuidMatcher.replaceAll(result -> "&lt;reference value=\"<a href=\"" + result.group(1) + "\">" + result.group(1) + "</a>\"&gt");
        return content;
    }

    private IParser getParser(MediaType mediaType, Supplier<IParser> parserFactor) {
        IParser p = parserFactor.get();
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        if (mediaType != null) {
            switch (mediaType.getParameters().getOrDefault("summary", "false")) {
                case "true": {
                    p.setSummaryMode(true);
                    break;
                }
                case "text": {
                    p.setEncodeElements(Set.of("*.text", "*.id", "*.meta", "*.(mandatory)"));
                    break;
                }
                case "data": {
                    p.setSuppressNarratives(true);
                }
            }
        }
        p.setPrettyPrint(true);
        return p;
    }

    private Optional<String> getResourceName(Resource resource, String uuid) {
        if (resource instanceof Bundle) {
            if (Objects.equals(uuid, resource.getIdElement().getIdPart())) {
                return Optional.of(resource.getClass().getAnnotation(ResourceDef.class).name());
            }
            return ((Bundle)resource).getEntry().stream().filter(c -> {
                if (c.hasResource()) {
                    return uuid.equals(c.getResource().getIdElement().getIdPart());
                }
                return uuid.equals(new IdType(c.getResponse().getLocation()).getIdPart());
            }).map(c -> {
                if (c.hasResource()) {
                    return c.getResource().getClass().getAnnotation(ResourceDef.class).name();
                }
                return new IdType(c.getResponse().getLocation()).getResourceType();
            }).findFirst();
        }
        return Optional.of(resource.getClass().getAnnotation(ResourceDef.class).name());
    }

    private Transformer newTransformer() throws TransformerConfigurationException {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
        return transformer;
    }

    private String simplifyXml(String xml) {
        try {
            Transformer transformer = this.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(xml)), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private String toJson(MediaType mediaType, Resource resource) throws IOException {
        IParser parser = this.getParser(mediaType, () -> ((FhirContext)this.fhirContext).newJsonParser());
        String content = parser.encodeResourceToString((IBaseResource)resource).replace("<", "&lt;").replace(">", "&gt;");
        Matcher urlMatcher = URL_PATTERN.matcher(content);
        content = urlMatcher.replaceAll(result -> "<a href=\"" + result.group() + "\">" + result.group() + "</a>");
        Matcher referenceUuidMatcher = JSON_REFERENCE_UUID_PATTERN.matcher(content);
        content = referenceUuidMatcher.replaceAll(result -> "\"reference\": \"<a href=\"" + result.group(1) + "\">" + result.group(1) + "</a>\",");
        Matcher idUuidMatcher = JSON_ID_UUID_AND_VERSION_PATTERN.matcher(content);
        content = idUuidMatcher.replaceAll(result -> {
            Optional<String> resourceName = this.getResourceName(resource, result.group(1));
            return resourceName.map(rN -> "\"id\": \"<a href=\"" + rN + "/" + result.group(1) + "\">" + result.group(1) + "</a>\",\n" + result.group(2) + "\"meta\": {\n" + result.group(3) + "\"versionId\": \"<a href=\"" + rN + "/" + result.group(1) + "/_history/" + result.group(4) + "\">" + result.group(4) + "</a>\",").orElse(result.group(0));
        });
        return content;
    }
}

