/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import java.util.regex.Matcher;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;

public class SearchSetTask
extends AbstractSearchSet<Task> {
    public SearchSetTask(int defaultPageCount) {
        super(defaultPageCount, Task.class);
    }

    protected Row toRow(ElementId id, Task resource) {
        Matcher matcher;
        String status = resource.hasStatus() ? resource.getStatus().toCode() : "";
        String processDomain = "";
        String processName = "";
        String processVersion = "";
        if (resource.getInstantiatesCanonical() != null && !resource.getInstantiatesCanonical().isBlank() && (matcher = INSTANTIATES_CANONICAL_PATTERN.matcher(resource.getInstantiatesCanonical())).matches()) {
            processDomain = matcher.group("domain");
            processName = matcher.group("processName");
            processVersion = matcher.group("processVersion");
        }
        String messageName = resource.getInput().stream().filter(this.isStringParam("http://dsf.dev/fhir/CodeSystem/bpmn-message", "message-name")).findFirst().map(c -> (String)((StringType)c.getValue()).getValue()).orElse("");
        String requester = resource.hasRequester() && resource.getRequester().hasIdentifier() && resource.getRequester().getIdentifier().hasValue() ? resource.getRequester().getIdentifier().getValue() : "";
        String businessKeyOrIdentifier = Task.TaskStatus.DRAFT.equals((Object)resource.getStatus()) ? resource.getIdentifier().stream().filter(i -> i.hasSystem() && "http://dsf.dev/sid/task-identifier".equals(i.getSystem()) && i.hasValue()).map(Identifier::getValue).findFirst().map(v -> {
            String[] parts = v.split("/");
            return parts.length > 0 ? parts[parts.length - 1] : "";
        }).orElse("") : resource.getInput().stream().filter(this.isStringParam("http://dsf.dev/fhir/CodeSystem/bpmn-message", "business-key")).findFirst().map(c -> (String)((StringType)c.getValue()).getValue()).orElse("");
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, status, processDomain, processName, processVersion, messageName, requester, businessKeyOrIdentifier, lastUpdated);
    }

    private record Row(ElementId id, String status, String processDomain, String processName, String processVersion, String messageName, String requester, String businessKeyOrIdentifier, String lastUpdated) {
    }
}

