/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Subscription;

public class SearchSetSubscription
extends AbstractSearchSet<Subscription> {
    public SearchSetSubscription(int defaultPageCount) {
        super(defaultPageCount, Subscription.class);
    }

    protected Row toRow(ElementId id, Subscription resource) {
        String status = resource.hasStatus() ? resource.getStatus().toCode() : "";
        String reason = resource.hasReasonElement() && resource.getReasonElement().hasValue() ? (String)resource.getReasonElement().getValue() : "";
        String criteria = resource.hasCriteriaElement() && resource.getCriteriaElement().hasValue() ? (String)resource.getCriteriaElement().getValue() : "";
        String channelType = resource.hasChannel() && resource.getChannel().hasTypeElement() && resource.getChannel().getTypeElement().hasCode() ? resource.getChannel().getTypeElement().getCode() : "";
        String channelPayload = resource.hasChannel() && resource.getChannel().hasPayloadElement() && resource.getChannel().getPayloadElement().hasCode() ? resource.getChannel().getPayloadElement().getCode() : "";
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, status, reason, criteria, channelType, channelPayload, lastUpdated);
    }

    private record Row(ElementId id, String status, String reason, String criteria, String channelType, String channelPayload, String lastUpdated) {
    }
}

