/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Resource;

public class SearchSetQuestionnaireResponse
extends AbstractSearchSet<QuestionnaireResponse> {
    public SearchSetQuestionnaireResponse(int defaultPageCount) {
        super(defaultPageCount, QuestionnaireResponse.class);
    }

    protected Row toRow(ElementId id, QuestionnaireResponse resource) {
        String status = resource.hasStatus() ? resource.getStatus().toCode() : "";
        String questionnaire = resource.hasQuestionnaireElement() && resource.getQuestionnaireElement().hasValue() ? ((String)resource.getQuestionnaireElement().getValue()).replaceAll("\\|", " \\| ") : "";
        String businessKey = resource.getItem().stream().filter(i -> "business-key".equals(i.getLinkId()) && i.hasAnswer() && i.getAnswer().size() == 1 && i.getAnswerFirstRep().hasValueStringType()).map(i -> (String)i.getAnswerFirstRep().getValueStringType().getValue()).findFirst().orElse("");
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, status, questionnaire, businessKey, lastUpdated);
    }

    private record Row(ElementId id, String status, String questionnaire, String businessKey, String lastUpdated) {
    }
}

