/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.Resource;

public class SearchSetOrganizationAffiliation
extends AbstractSearchSet<OrganizationAffiliation> {
    public SearchSetOrganizationAffiliation(int defaultPageCount) {
        super(defaultPageCount, OrganizationAffiliation.class);
    }

    protected Row toRow(ElementId id, OrganizationAffiliation resource) {
        boolean active = resource.hasActiveElement() && resource.getActiveElement().hasValue() && Boolean.TRUE.equals(resource.getActiveElement().getValue());
        ElementId parentOrganization = ElementId.from(resource, OrganizationAffiliation::hasOrganization, OrganizationAffiliation::getOrganization);
        ElementId participatingOrganization = ElementId.from(resource, OrganizationAffiliation::hasParticipatingOrganization, OrganizationAffiliation::getParticipatingOrganization);
        String role = resource.getCode().stream().flatMap(c -> c.getCoding().stream()).filter(c -> "http://dsf.dev/fhir/CodeSystem/organization-role".equals(c.getSystem())).map(Coding::getCode).collect(Collectors.joining(", "));
        ElementId endpoint = ElementId.from(resource, OrganizationAffiliation::hasEndpoint, OrganizationAffiliation::getEndpointFirstRep);
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, active, parentOrganization, participatingOrganization, role, endpoint, lastUpdated);
    }

    private record Row(ElementId id, boolean active, ElementId parentOrganization, ElementId participatingOrganization, String role, ElementId endpoint, String lastUpdated) {
    }
}

