/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Resource;

public class SearchSetOrganization
extends AbstractSearchSet<Organization> {
    public SearchSetOrganization(int defaultPageCount) {
        super(defaultPageCount, Organization.class);
    }

    protected Row toRow(ElementId id, Organization resource) {
        boolean active = resource.hasActiveElement() && resource.getActiveElement().hasValue() && Boolean.TRUE.equals(resource.getActiveElement().getValue());
        String identifier = this.getIdentifierValues(resource, Organization::hasIdentifier, Organization::getIdentifier, "http://dsf.dev/sid/organization-identifier");
        String name = resource.hasName() ? resource.getName() : "";
        ElementId endpoint = ElementId.from(resource, Organization::hasEndpoint, Organization::getEndpointFirstRep);
        int endpointCount = resource.hasEndpoint() ? resource.getEndpoint().size() : 0;
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, active, identifier, name, endpoint, endpointCount, lastUpdated);
    }

    private record Row(ElementId id, boolean active, String identifier, String name, ElementId endpoint, int endpointCount, String lastUpdated) {
    }
}

