/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.fhir.adapter;

import dev.dsf.fhir.adapter.AbstractSearchSet;
import dev.dsf.fhir.adapter.ElementId;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Resource;

public class SearchSetMetadataResource<M extends MetadataResource>
extends AbstractSearchSet<M> {
    public SearchSetMetadataResource(int defaultPageCount, Class<M> matchResourceType) {
        super(defaultPageCount, matchResourceType, "searchsetMetadataResource");
    }

    protected Row toRow(ElementId id, M resource) {
        String status = resource.hasStatus() ? resource.getStatus().toCode() : "";
        String urlVersion = (resource.hasUrlElement() && resource.getUrlElement().hasValue() ? (String)resource.getUrlElement().getValue() : "") + " | " + (resource.hasVersionElement() && resource.getVersionElement().hasValue() ? (String)resource.getVersionElement().getValue() : "");
        String titleOrName = resource.hasTitleElement() && resource.getTitleElement().hasValue() ? (String)resource.getTitleElement().getValue() : (resource.hasNameElement() && resource.getNameElement().hasValue() ? (String)resource.getNameElement().getValue() : "");
        String lastUpdated = this.formatLastUpdated((Resource)resource);
        return new Row(id, status, urlVersion, titleOrName, lastUpdated);
    }

    private record Row(ElementId id, String status, String urlVersion, String titleOrName, String lastUpdated) {
    }
}

